package com.thebeastshop.common.converter;

import java.util.List;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-04-25 17:15
 */
public class GenericPOJOConverter<VO, PO, DTO>
        extends GenericPOVOConverter<VO, PO> implements POJOConverter<VO, PO, DTO> {

    protected final Class<DTO> dtoClass;

    public GenericPOJOConverter(Class<VO> voClass, Class<PO> poClass, Class<DTO> dtoClass) {
        super(voClass, poClass);
        this.dtoClass = dtoClass;
    }

    @Override
    public Class<DTO> getDTOClass() {
        return dtoClass;
    }

    @Override
    public PO poFromDTO(DTO dto) {
        return converterFrom(dto, poClass);
    }

    @Override
    public VO voFromDTO(DTO dto) {
        return converterFrom(dto, voClass);
    }

    @Override
    public DTO dtoFromObject(Object obj) {
        return converterFrom(obj, dtoClass);
    }

    @Override
    public List<PO> poListFromDTOList(List<DTO> dtos) {
        return converterListFrom(dtos, poClass);
    }

    @Override
    public List<DTO> dtoListFromPOList(List<PO> pos) {
        return converterListFrom(pos, dtoClass);
    }

    @Override
    public List<DTO> dtoListFromList(List<?> list) {
        return converterListFrom(list, dtoClass);
    }

}
