/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.validation;

import com.thebeastshop.common.exception.BaseErrorCode;
import com.thebeastshop.common.exception.CommonErrorCode;
import com.thebeastshop.common.exception.ValidationException;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.MetaUtil;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validation {
    private static final Logger log = LoggerFactory.getLogger(Validation.class);

    public static void assertNotNull(Object object, BaseErrorCode errorCode, String msg) {
        if (object == null) {
            Validation.throwValidationException(errorCode, msg);
        }
    }

    public static void assertNotNull(Object object, String msg) {
        if (object == null) {
            Validation.throwValidationException(CommonErrorCode.RESULT_NULL, msg);
        }
    }

    public static void assertNotEmpty(Collection collection, BaseErrorCode errorCode, String msg) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            Validation.throwValidationException(errorCode, msg);
        }
    }

    public static void assertNotEmpty(Collection collection, String msg) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            Validation.throwValidationException(CommonErrorCode.RESULT_EMPTY, msg);
        }
    }

    public static void assertNotEmpty(CharSequence str, BaseErrorCode errorCode, String msg) {
        if (EmptyUtil.isEmpty(str)) {
            Validation.throwValidationException(errorCode, msg);
        }
    }

    public static void assertNotEmpty(String str, String msg) {
        if (EmptyUtil.isEmpty(str)) {
            Validation.throwValidationException(CommonErrorCode.RESULT_EMPTY, msg);
        }
    }

    public static void assertNotEmpty(Map map, BaseErrorCode errorCode, String msg) {
        if (MapUtils.isEmpty((Map)map)) {
            Validation.throwValidationException(errorCode, msg);
        }
    }

    public static void assertNotEmpty(Map map, String msg) {
        if (MapUtils.isEmpty((Map)map)) {
            Validation.throwValidationException(CommonErrorCode.RESULT_EMPTY, msg);
        }
    }

    public static void assertTrue(boolean condition, BaseErrorCode errorCode, String msg) {
        if (!condition) {
            Validation.throwValidationException(errorCode, msg);
        }
    }

    public static void assertTrue(boolean condition, String msg) {
        if (!condition) {
            Validation.throwValidationException(CommonErrorCode.RESULT_NOT_EXPECTED, msg);
        }
    }

    public static void assertTrue(boolean condition, BaseErrorCode exceptionCode) {
        Validation.assertTrue(condition, exceptionCode, exceptionCode.getMessage());
    }

    public static void assertTrue(boolean condition) {
        Validation.assertTrue(condition, CommonErrorCode.RESULT_NOT_EXPECTED, CommonErrorCode.RESULT_NOT_EXPECTED.getMessage());
    }

    public static void assertEquals(Object excepted, Object source) {
        Validation.assertEquals(excepted, source, CommonErrorCode.RESULT_NOT_EXPECTED, CommonErrorCode.RESULT_NOT_EXPECTED.getMessage());
    }

    public static void assertEquals(Object excepted, Object source, BaseErrorCode errorCode) {
        Validation.assertEquals(excepted, source, CommonErrorCode.RESULT_NOT_EXPECTED, CommonErrorCode.RESULT_NOT_EXPECTED.getMessage());
    }

    public static void assertEquals(Object excepted, Object source, String msg) {
        Validation.assertEquals(excepted, source, CommonErrorCode.RESULT_NOT_EXPECTED, msg);
    }

    public static void assertEquals(Object excepted, Object source, BaseErrorCode errorCode, String msg) {
        if (excepted == source) {
            return;
        }
        if (excepted == null || source == null || !excepted.equals(source)) {
            String defaultMsg = "\tExpected: " + excepted + "\n\tSource: " + source;
            String throwMsg = msg != null && msg.length() > 0 ? msg : "\n" + defaultMsg;
            Validation.throwParamException(errorCode, throwMsg);
        }
    }

    public static void rejectIf(Boolean condition, BaseErrorCode exceptionCode, String msg) {
        if (condition.booleanValue()) {
            Validation.throwValidationException(exceptionCode, msg);
        }
    }

    public static void rejectIf(Boolean condition, BaseErrorCode exceptionCode) {
        Validation.rejectIf(condition, exceptionCode, exceptionCode.getMessage());
    }

    public static void rejectIf(Boolean condition, String msg) {
        if (condition.booleanValue()) {
            Validation.throwValidationException(CommonErrorCode.VALID_FAIL, msg);
        }
    }

    public static void paramNotNull(Object obj, String msg) {
        if (obj == null) {
            Validation.throwParamException(CommonErrorCode.NULL_PARAM, msg);
        }
    }

    public static void paramNotEmpty(Collection collection, String msg) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            Validation.throwParamException(CommonErrorCode.EMPTY_PARAM, msg);
        }
    }

    public static void paramNotEmpty(CharSequence str, String msg) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            Validation.throwParamException(CommonErrorCode.EMPTY_PARAM, msg);
        }
    }

    public static void paramNotEmpty(Map map, String msg) {
        if (MapUtils.isEmpty((Map)map)) {
            Validation.throwParamException(CommonErrorCode.EMPTY_PARAM, msg);
        }
    }

    public static void paramMust(Boolean condition, String msg) {
        if (!condition.booleanValue()) {
            Validation.throwParamException(CommonErrorCode.ILLEGAL_PARAM, msg);
        }
    }

    private static StackTraceElement getStackElement(int index) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[index];
        return stackTraceElement;
    }

    private static void throwValidationException(BaseErrorCode errorCode, String msg) {
        Validation.throwValidationException("\u6570\u636e\u6821\u9a8c\u9519\u8bef", errorCode, msg, 5);
    }

    private static void throwParamException(BaseErrorCode errorCode, String msg) {
        Validation.throwValidationException("\u53c2\u6570\u6821\u9a8c\u9519\u8bef", errorCode, msg, 5);
    }

    private static void throwValidationException(String type, BaseErrorCode errorCode, String msg, int index) {
        StackTraceElement stackTraceElement = Validation.getStackElement(index);
        String class_method = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
        String appId = MetaUtil.APP_NAME;
        if (msg != null) {
            String text = "[" + appId + "] [" + type + ": " + errorCode.getErrorCode() + "] \u8c03\u7528\u65b9\u6cd5[" + class_method + "]\u65f6\n\n\t" + errorCode.getMessage() + ":\n\t\t" + msg + "\n\n";
            log.error(text);
            throw new ValidationException(errorCode, errorCode.getMessage() + ": " + msg);
        }
        String text = "[" + appId + "] [" + type + ": " + errorCode.getErrorCode() + "] \u8c03\u7528\u65b9\u6cd5[" + class_method + "]\u65f6\n\n\t" + errorCode.getMessage() + "\n";
        log.error(text);
        throw new ValidationException(errorCode, errorCode.getMessage());
    }
}

