/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.converter.BeanConverterHandlerManager;
import com.thebeastshop.common.converter.ConverterSupport;
import com.thebeastshop.common.converter.GenericBeanConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.ConcurrentReferenceHashMap;

import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

/**
 * @author Roy.Chen
 * @version $Id: ReflectionUtil.java, v 0.1 2015-08-12 18:20
 */
public class BeanUtil {

    private final static Set<Class<?>> primitiveSet;

    static {
        primitiveSet = new HashSet<>();
        primitiveSet.add(Boolean.class);
        primitiveSet.add(Character.class);
        primitiveSet.add(String.class);
        primitiveSet.add(Short.class);
        primitiveSet.add(Integer.class);
        primitiveSet.add(Long.class);
        primitiveSet.add(Float.class);
        primitiveSet.add(Double.class);
        primitiveSet.add(Void.class);
    }

    public static BeanConverterHandlerManager matchHandlerManager(Class<?> fromClass, Class<?> toClass) {
        return ConverterSupport.matchHandlerManager(fromClass, toClass);
    }


    /**
     *
     * @param src  源bean
     * @param clz   目标bean class
     * @return
     */
    public static <T> T buildFrom(Object src, Class<T> clz) {
        T obj  =  buildFroms(src, clz, null);
        return obj;
    }
    /**
     *
     * @param src  源bean
     * @param clazz   目标bean class
     * @param ignoreProperties 忽略的属性
     * @return
     */
    public static <T> T buildFroms(Object src, Class<T> clazz, String[] ignoreProperties) {
        if (src == null) {
            return null;
        }
        T ret = null;
        try {
            ret = clazz.newInstance();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (ret == null) {
            return null;
        }
        Class fromClass = src.getClass();
        BeanConverterHandlerManager handlerManager = matchHandlerManager(fromClass, clazz);
        String[] ignoreFields = ignoreProperties;
        if (handlerManager != null) {
            if (ignoreFields == null) {
                ignoreFields = handlerManager.getIgnoreFields();
            }
            GenericBeanConverter.copyProperties(src, ret, ignoreFields);
            handlerManager.afterCopyProperties(src, ret);
        }
        else {
            GenericBeanConverter.copyProperties(src, ret, ignoreFields);
        }
        convertParameterizedTypeField(ret);
        return ret;
    }
    public static <T> T deepCopy(Object src, Class<T> clz) {
        if (src == null) {
            return  null;
        }
        Object targetObj = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(src);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            targetObj = (T)objectInputStream.readObject();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }finally {
            try {
                outputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (T)targetObj;
    }
    private static <T> void convertParameterizedTypeField(T obj){
        if(obj == null){
            return;
        }
        try{
            for(Field f: obj.getClass().getDeclaredFields()){
                if(f.getType() == java.util.List.class){
                    Type genericType = f.getGenericType();
                    if(genericType == null) {
                        continue;
                    }
                    // 如果是泛型参数的类型
                    if(genericType instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType) genericType;
                        Class<?> accountPrincipalApproveClazz = (Class<?>) pt.getActualTypeArguments()[0];
                        if(!isPrimitiveWrapper(accountPrincipalApproveClazz)){
                            f.setAccessible(true);
                            List<?> list = (List<?>)f.get(obj);
                            List<?> returnList = buildListFrom(list,accountPrincipalApproveClazz);
                            f.set(obj,returnList);
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private static <T> boolean isPrimitiveWrapper(Class<T> tClass){
        return primitiveSet.contains(tClass);
    }

    /**
     *
     * @param src  源bean
     * @param clz   目标bean class
     * @return
     */
    public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz) {
        return buildListFrom(src, clz, null);
    }

    /**
     *
     * @param src  源bean
     * @param clz   目标bean class
     * @param ignoreProperties 忽略的属性
     * @return
     */
    public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz, String[] ignoreProperties) {
        if (CollectionUtils.isEmpty(src)) {
            return Collections.emptyList();
        }

        List<T> objs = new ArrayList<T>(src.size());
        for (Object o : src) {
            T obj = buildFroms(o, clz, ignoreProperties);
            objs.add(obj);
        }
        return objs;
    }


    private static <K, V> Map<K, V> newEmptyMap(Class srcClass) {
        if (ConcurrentReferenceHashMap.class.isAssignableFrom(srcClass)) {
            return new ConcurrentReferenceHashMap<>();
        }
        if (ConcurrentSkipListMap.class.isAssignableFrom(srcClass)) {
            return new ConcurrentSkipListMap<>();
        }
        if (ConcurrentHashMap.class.isAssignableFrom(srcClass)) {
            return new ConcurrentHashMap<>();
        }
        if (LinkedHashMap.class.isAssignableFrom(srcClass)) {
            return new LinkedHashMap<>();
        }
        return new HashMap<>();
    }


    public static <K, V> Map<K, V> buildMapFrom(
            Map<K, ?> src,
            Class<V> valueClass) {
        return buildMapFrom(src, valueClass, null);
    }


    public static <K, V> Map<K, V> buildMapFrom(
            Map<K, ?> src,
            Class<V> valueClass,
            String[] ignoreProperties) {
        if (MapUtils.isEmpty(src)) {
            return newEmptyMap(src.getClass());
        }
        Map<K, V> resultMap = newEmptyMap(src.getClass());
        for (Map.Entry<K, ?> entry : src.entrySet()) {
            K key = entry.getKey();
            Object value = entry.getValue();
            V newValue = buildFroms(value, valueClass, ignoreProperties);
            resultMap.put(key, newValue);
        }
        return resultMap;
    }
    public static Map<String, Object> bean2Map(Object obj) throws Exception {
        HashMap map = new HashMap();
        HashSet fields = new HashSet();

        for(Class clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }

        Iterator var4 = fields.iterator();

        while(var4.hasNext()) {
            Field field = (Field)var4.next();
            field.setAccessible(true);
            map.put(field.getName(), field.get(obj));
        }

        return map;
    }
	/**
	 * 获取空值的字段名
	 *
	 * @param source
	 * @return
	 */
	public static String[] getNullPropertyNames(Object source) {
		final BeanWrapper src = new BeanWrapperImpl(source);
		java.beans.PropertyDescriptor[] pds = src.getPropertyDescriptors();

		Set<String> emptyNames = new HashSet<String>();
		for (java.beans.PropertyDescriptor pd : pds) {
			Object srcValue = src.getPropertyValue(pd.getName());
			if (srcValue == null) {
                emptyNames.add(pd.getName());
            }
		}
		String[] result = new String[emptyNames.size()];
		return emptyNames.toArray(result);
	}

	/**
	 * 覆盖字段值（排除空值）
	 *
	 * @param src
	 * @param target
	 */
	public static void copyPropertiesIgnoreNull(Object src, Object target) {
		BeanUtils.copyProperties(src, target, getNullPropertyNames(src));
	}
}
