/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.Page;

public class PageCond
extends BaseDO {
    private Integer currpage = 1;
    private Integer offset = 0;
    private Integer pagenum = 20;

    public PageCond() {
    }

    public PageCond(Integer currpage, Integer pagenum) {
        this.setCurrpage(currpage);
        this.setPagenum(pagenum);
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
        if (offset != null && this.pagenum != null) {
            this.currpage = offset / this.pagenum + 1;
        }
    }

    public Integer getCurrpage() {
        return this.currpage;
    }

    public void setCurrpage(Integer currpage) {
        this.currpage = currpage;
        if (currpage != null && this.pagenum != null) {
            this.offset = (currpage - 1) * this.pagenum;
        }
    }

    public Integer getPagenum() {
        return this.pagenum;
    }

    public void setPagenum(Integer pagenum) {
        this.pagenum = pagenum;
    }

    public String getCriteriaStr() {
        if (this.currpage == null) {
            return "";
        }
        Integer pagestart = this.getPageStart();
        return " LIMIT " + pagestart + "," + this.pagenum + "  ";
    }

    public String getLimitStr() {
        if (this.currpage == null) {
            return "";
        }
        Page page = this.getPage();
        if (page == null) {
            return "";
        }
        return " LIMIT " + page.getMySqlBegin() + "," + page.getPageSize() + "  ";
    }

    public int getPageStart() {
        return this.currpage != null && this.currpage > 0 ? (this.currpage - 1) * this.pagenum : 0;
    }

    public void setPage(Page page) {
        if (page != null) {
            this.currpage = page.getCurrent();
            this.pagenum = page.getPageSize();
        }
    }

    public Page getPage() {
        if (this.pagenum == null || this.pagenum < 0 || this.currpage == null) {
            return null;
        }
        if (this.offset > 0) {
            Page page = new Page();
            page.setBegin(this.offset);
            page.setPageSize(this.pagenum);
            return page;
        }
        return new Page((int)this.currpage, this.pagenum);
    }
}

