/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.common.utils;

import java.math.BigDecimal;
import java.util.Random;

/**
 * @author Royan
 * @version $Id: StringUtil.java, v 0.1 2015-07-16 上午11:01
 */
public class StringUtil {

    public static final String randomCharAndInts = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final String randomChars       = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String randomInts        = "0123456789";

    /**
     * 获得指定长度的随机字符串（数字+英文大小写）
     *
     * @param length 指定长度
     * @return 随机字符串
     */
    public static String getRandomString(int length) {
        return getRandomString(length, randomCharAndInts);
    }

    /**
     * 根据指定随机字符得指定长度的随机字符串
     *
     * @param length      指定长度
     * @param randomChars 指定随机字符
     * @return 随机字符串
     */
    public static String getRandomString(int length, String randomChars) {
        Random random = new Random();
        int randomCharsLength = randomChars.length();
        StringBuffer sf = new StringBuffer(length);
        for (int i = 0; i < length; i++) {
            sf.append(randomChars.charAt(random.nextInt(randomCharsLength)));
        }
        return sf.toString();
    }

    /**
     * 将二进制转换成16进制
     *
     * @param buf
     * @return
     */
    public static String parseByte2HexStr(byte buf[]) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; i++) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    /**
     * 本地转unicode
     * @param s
     * @return
     */
    public static String nativeToUnicode(String s) {
        if (EmptyUtil.isEmpty(s)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            if (c >= 0 && c <= 255) {
                sb.append(c);
            } else {
                sb.append("\\u" + Integer.toHexString(c));
            }
        }
        return sb.toString();
    }

    /**
     * unicode转本地
     * @param s
     * @return
     */
    public static String unicodeToNative(String s) {
        if (EmptyUtil.isEmpty(s)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = -1;
        int pos = 0;

        while ((i = s.indexOf("\\u", pos)) != -1) {
            sb.append(s.substring(pos, i));
            if (i + 5 < s.length()) {
                pos = i + 6;
                sb.append((char) Integer.parseInt(s.substring(i + 2, i + 6), 16));
            }
        }
        return sb.toString();
    }

    /**
     * 将16进制转换为二进制
     *
     * @param hexStr
     * @return
     */
    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1)
            return null;
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; i++) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte) (high * 16 + low);
        }
        return result;
    }

    public static boolean isValidLong(String str){
        try{
            long _v = Long.parseLong(str);
            return true;
        }catch(NumberFormatException e){
            return false;
        }
    }

    public static boolean isBigDecimal(String str) {
        try{
            BigDecimal bd = new BigDecimal(str);
            return true;
        }catch(NumberFormatException e) {
            return false;
        }
    }

    public static boolean isInteger(String str) {
        try{
            Integer.parseInt(str);
            return true;
        }catch(NumberFormatException e) {
            return false;
        }
    }

    public static String queryCallbackStr(String value){
        if(EmptyUtil.isNotEmpty(value) && (value.indexOf("[")>-1) && (value.indexOf("]")>value.indexOf("["))){
            return value.substring(1, value.indexOf(']'));
        }
        return null;
    }

    public static String get(String str){
        return str==null?"":str;
    }

    /**
     * 从方括号中截取字符串
     * @param value
     * @return
     */
    public static String substrForSquareBrackets(final String value){
        return isContainsSquareBrackets(value) ? value.substring(1, value.indexOf(']')) : value;
    }

    public static boolean isContainsSquareBrackets(final String value){
        int leftIdx = value.indexOf("["), rightIdx = value.indexOf("]");
        return EmptyUtil.isNotEmpty(value) && (leftIdx >- 1) && (rightIdx > leftIdx);
    }

    //    public static void main(String[] args) {
    //        System.out.println(StringUtil.getRandomString(32));
    //    }

}