package com.thebeastshop.common;

/**
 * 含分页的条件类
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-09-07 16:26
 */
public class PageCond extends BaseDO {

    /**
     * 第几页
     */
    private Integer currpage = 1;
    /**
     * 起始数
     */
    private Integer offset = 0;
    /**
     * 每页的数量
     */
    private Integer pagenum = 20;

    public PageCond() {
    }

    public PageCond(Integer currpage, Integer pagenum) {
        setCurrpage(currpage);
        setPagenum(pagenum);
    }


    public Integer getOffset() {
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
        if (offset != null && pagenum != null) {
            this.currpage = offset / pagenum + 1;
        }
    }

    public Integer getCurrpage() {
        return currpage;
    }

    public void setCurrpage(Integer currpage) {
        this.currpage = currpage;
        if (currpage != null && pagenum != null) {
            this.offset = (currpage - 1) * pagenum;
        }
    }

    public Integer getPagenum() {
        return pagenum;
    }

    public void setPagenum(Integer pagenum) {
        this.pagenum = pagenum;
    }

    /**
     * 获取分页 Limit后的 str
     *
     * @return
     */
    public String getCriteriaStr() {
        if (currpage == null) {
            return "";
        }
        Integer pagestart = getPageStart();

        return new StringBuilder(" LIMIT ").append(pagestart).append(",").append(pagenum).append("  ").toString();
    }

    /**
     * 分页字符串
     * @return
     */
    public String getLimitStr() {
        if (currpage == null) {
            return "";
        }
        Page page = getPage();
        if (page == null) {
            return "";
        }
        return new StringBuilder(" LIMIT ")
                .append(page.getMySqlBegin())
                .append(",")
                .append(page.getPageSize())
                .append("  ").toString();
    }

    public int getPageStart() {
        return (currpage != null && currpage > 0 ? (currpage - 1) * pagenum : 0);
    }


    /**
     * 设置分页对象
     * @param page
     */
    public void setPage(Page page) {
        if (page != null) {
            this.currpage = page.getCurrent();
            this.pagenum = page.getPageSize();
        }
    }

    /**
     * 获取分页对象
     * @return
     */
    public Page getPage() {
        if (pagenum == null || pagenum < 0 || currpage == null) {
            return null;
        }

        if(offset > 0){
            Page page = new Page();
            page.setBegin(offset);
            page.setPageSize(pagenum);
            return page;
        }else{
            return new Page(currpage, pagenum);
        }
    }
}
