package com.thebeastshop.common.http;

import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:me@yuanchongyu.com">Royan</a>
 * @project unicom-repo
 * @createDate 2012-12-29 上午10:43:41
 */
public class HttpResponse {
    private Map<String, String> cookieMap;

    private Map<String, String> headerMap;

    private String body;

    private byte[] byteBody;

    private int statusCode;

    public Map<String, String> getCookieMap() {
        return cookieMap;
    }

    public void setCookieMap(Map<String, String> cookieMap) {
        this.cookieMap = cookieMap;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public byte[] getByteBody() {
        return byteBody;
    }

    public void setByteBody(byte[] byteBody) {
        this.byteBody = byteBody;
    }

    public Map<String, String> getHeaderMap() {
        return headerMap;
    }

    public List<Header> getHeaderList() {
        List<Header> headers = new ArrayList<Header>();
        if (this.headerMap != null) {
            for (Map.Entry<String, String> e : headerMap.entrySet()) {
                headers.add(new BasicHeader(e.getKey(), e.getValue()));
            }
        }
        return headers;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

}
