package com.thebeastshop.common.converter;


import java.util.HashMap;
import java.util.Map;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-04-27 18:14
 */
public class ToList<Source> {

    private Map<Class<?>, BeanConverterHandlerManager<Source, ?>> toMap = new HashMap<>();

    public <Target> BeanConverterHandlerManager<Source, Target> to(Class<Target> targetClass) {
        BeanConverterHandlerManager<Source, Target> handlerManager = (BeanConverterHandlerManager<Source, Target>) toMap.get(targetClass);
        if (handlerManager != null) {
            return handlerManager;
        }
        synchronized (this) {
            handlerManager = new BeanConverterHandlerManager<>();
            toMap.put(targetClass, handlerManager);
        }
        return handlerManager;
    }

    public <Target> BeanConverterHandlerManager<Source, Target> get(Class<Target> targetClass) {
        BeanConverterHandlerManager<Source, Target> result = (BeanConverterHandlerManager<Source, Target>) toMap.get(targetClass);
        if (result != null) {
            return result;
        }
        if (targetClass.equals(Object.class)) {
            return null;
        }
        return (BeanConverterHandlerManager<Source, Target>) get(targetClass.getSuperclass());
    }

}
