package com.thebeastshop.common.converter;

import org.apache.commons.collections.MapUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-04-27 18:10
 */
public class BeanConverterHandlerManager<Source, Target> {

    private Set<String> ignoreFields = new HashSet<>();

    private Map<String, BeanConverterFieldFilter<Source>> fieldFilterMap = new HashMap<>();

    private BeanConverterHandler<Source, Target> onCopy;

    private BeanConverterHandler<Source, Target> afterCopy;

    public synchronized BeanConverterHandlerManager ignore(String filedName) {
        ignoreFields.add(filedName);
        return this;
    }

    @Deprecated
    public synchronized BeanConverterHandlerManager addFieldFilter(String fieldName, BeanConverterFieldFilter<Source> filter) {
        ignore(fieldName);
        fieldFilterMap.put(fieldName, filter);
        return this;
    }

    public synchronized BeanConverterHandlerManager afterCopy(BeanConverterHandler<Source, Target> converterHandler) {
        this.afterCopy = converterHandler;
        return this;
    }


    public String[] getIgnoreFields() {
        String[] arr = null;
        if (!ignoreFields.isEmpty()) {
            arr = new String[ignoreFields.size()];
            int i = 0;
            for (String fieldName : ignoreFields) {
                arr[i++] = fieldName;
            }
        }
        return arr;
    }

    public BeanConverterHandler getOnConverter() {
        return onCopy;
    }

    public void setOnConverter(BeanConverterHandler onConverter) {
        this.onCopy = onConverter;
    }

    public BeanConverterHandler getAfterCopy() {
        return afterCopy;
    }

    public void setAfterCopy(BeanConverterHandler afterCopy) {
        this.afterCopy = afterCopy;
    }


    public void afterCopyProperties(Source sourceObj, Target targetObj) {
        if (MapUtils.isNotEmpty(fieldFilterMap)) {
            for (String fieldName : fieldFilterMap.keySet()) {
                BeanConverterFieldFilter<Source> fieldFilter = fieldFilterMap.get(fieldName);
                if (fieldFilter == null) continue;
                Object value = fieldFilter.fieldValueFrom(sourceObj);
                try {
                    org.apache.commons.beanutils.BeanUtils.setProperty(targetObj, fieldName, value);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        if (afterCopy != null) {
            afterCopy.copyFields(sourceObj, targetObj);
        }
    }
}
