package com.thebeastshop.common.log;

import com.thebeastshop.kit.prop.PropConfig;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2019-07-08 14:19
 */
public class AopLogger {

    private final Logger logger;

    private Boolean enable;

    public AopLogger(Class klazz) {
        this.logger = LoggerFactory.getLogger(klazz);
    }

    public void info(String msg) {
        if (isEnable()) {
            logger.info(msg);
        }
    }

    public void info(String msg, Object... args) {
        if (isEnable()) {
            logger.info(msg, args);
        }
    }

    public void error(String msg) {
        if (isEnable()) {
            logger.error(msg);
        }
    }

    public void error(String msg, Object... args) {
        if (isEnable()) {
            logger.error(msg, args);
        }
    }

    public boolean isEnable() {
        if (enable != null) {
            return enable;
        }
        String value = PropConfig.getProperties("beast.aop.log.enable");
        if (StringUtils.isBlank(value)) {
            enable = true;
        }
        enable = Boolean.valueOf(value);
        return enable;
    }

}
