package com.thebeastshop.common.spring;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

/**
 * <p>Title: thebeastshop</p>
 * <p>Copyright: Copyright (c) 2016</p>
 * @author Bryan Zhang
 * @date 2016-12-30
 * @description spring的上下文处理类
 */
public class SpringAware implements ApplicationContextAware {

	private static ApplicationContext applicationContext = null;

	public void setApplicationContext(ApplicationContext ac) throws BeansException {
		applicationContext = ac;
	}

	public static ApplicationContext getApplicationContext() {
		return applicationContext;
	}

	@SuppressWarnings("unchecked")
	public static <T> T getBean(String name) {
		return (T) applicationContext.getBean(name);
	}

	public static <T> T getBean(Class<T> clazz) {
		return (T) applicationContext.getBean(clazz);
	}

	public static void rollBack(){
		TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
	}
}
