/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.enums;

import com.thebeastshop.common.enums.CodeEnum;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public enum MemberLevelEnum implements CodeEnum<Integer>
{
    NORMAL(-1, 10, "\u6ce8\u518c\u7528\u6237", "\u6ce8\u518c", new BigDecimal("1.00"), new BigDecimal("1.00"), "https://img.thebeastshop.com/app/message/member_icon0.png", "member/privilege/level-icon/level-zero.jpg", new BigDecimal("0.00"), null, null, "https://img.thebeastshop.com/member/privilege/upgrade-icon/level-zero.jpg"),
    VIP(0, 20, "\u677e\u9f20\u4f1a\u5458", "\u677e\u9f20", new BigDecimal("1.00"), new BigDecimal("0.95"), "https://img.thebeastshop.com/app/message/member_icon1.png", "member/privilege/level-icon/level-one.jpg", new BigDecimal("1"), null, "\u60a8\u5df2\u4eab\u53d7\u677e\u9f20\u4f1a\u5458\u751f\u65e59.5\u6298", "https://img.thebeastshop.com/member/privilege/upgrade-icon/level-one.jpg"),
    VIP1(4, 30, "\u5154\u5b50\u4f1a\u5458", "\u5154\u5b50", new BigDecimal("1.00"), new BigDecimal("0.95"), "https://img.thebeastshop.com/app/message/member_icon5.png", "member/privilege/level-icon/level-five.jpg", new BigDecimal("3000.00"), "\u60a8\u5df2\u4eab\u53d7\u5154\u5b50\u4f1a\u5458\u6298\u626395\u6298", "\u60a8\u5df2\u4eab\u53d7\u5154\u5b50\u4f1a\u5458\u751f\u65e595\u6298", "https://img.thebeastshop.com/member/privilege/upgrade-icon/level-five.jpg"),
    VIP2(1, 40, "\u5c0f\u732b\u4f1a\u5458", "\u5c0f\u732b", new BigDecimal("0.95"), new BigDecimal("0.90"), "https://img.thebeastshop.com/app/message/member_icon2.png", "member/privilege/level-icon/level-two.jpg", new BigDecimal("5000.00"), "\u60a8\u5df2\u4eab\u53d7\u5c0f\u732b\u4f1a\u5458\u6298\u62639.5\u6298", "\u60a8\u5df2\u4eab\u53d7\u5c0f\u732b\u4f1a\u5458\u751f\u65e59\u6298", "https://img.thebeastshop.com/member/privilege/upgrade-icon/level-two.jpg"),
    VIP3(2, 50, "\u8001\u864e\u4f1a\u5458", "\u8001\u864e", new BigDecimal("0.90"), new BigDecimal("0.85"), "https://img.thebeastshop.com/app/message/member_icon4.png", "member/privilege/level-icon/level-three.jpg", new BigDecimal("10000.00"), "\u60a8\u5df2\u4eab\u53d7\u8001\u864e\u4f1a\u5458\u6298\u62639\u6298", "\u60a8\u5df2\u4eab\u53d7\u8001\u864e\u4f1a\u5458\u751f\u65e58.5\u6298", "https://img.thebeastshop.com/member/privilege/upgrade-icon/level-three.jpg"),
    VIP4(3, 60, "\u5927\u8c61\u4f1a\u5458", "\u5927\u8c61", new BigDecimal("0.90"), new BigDecimal("0.80"), "https://img.thebeastshop.com/app/message/member_icon3.png", "member/privilege/level-icon/level-four.jpg", new BigDecimal("50000.00"), "\u60a8\u5df2\u4eab\u53d7\u5927\u8c61\u4f1a\u5458\u6298\u62639\u6298", "\u60a8\u5df2\u4eab\u53d7\u5927\u8c61\u4f1a\u5458\u751f\u65e58\u6298", "https://img.thebeastshop.com/member/privilege/upgrade-icon/level-four.jpg");

    private final int code;
    private final int level;
    private final String name;
    private final String shortName;
    private final BigDecimal levelAmountCondition;
    private final BigDecimal bdayDiscountRatio;
    private final String messageImage;
    private final String avatarUrl;
    private final String upgradeUrl;
    private final BigDecimal threshold;
    private final String description;
    private final String bdDescription;
    private String startTime = "2017-07-31 00:00:00";
    private String endTime = "2017-08-31 23:59:59";
    public static final List<MemberLevelEnum> ALL;

    private MemberLevelEnum(int code, int level, String name, String shortName, BigDecimal levelAmountCondition, BigDecimal bdayDiscountRatio, String messageImage, String avatarUrl, BigDecimal threshold, String description, String bdDescription, String upgradeUrl) {
        this.code = code;
        this.level = level;
        this.name = name;
        this.shortName = shortName;
        this.levelAmountCondition = levelAmountCondition;
        this.bdayDiscountRatio = bdayDiscountRatio;
        this.avatarUrl = "https://img.thebeastshop.com/" + avatarUrl;
        this.messageImage = messageImage;
        this.threshold = threshold;
        this.description = description;
        this.bdDescription = bdDescription;
        this.upgradeUrl = upgradeUrl;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BigDecimal getLevelAmountCondition() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date start = sdf.parse(this.startTime);
            Date end = sdf.parse(this.endTime);
            Date now = new Date();
            if (now.after(start) && now.before(end) && this.levelAmountCondition.equals(new BigDecimal("0.90"))) {
                return new BigDecimal("0.88");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this.levelAmountCondition;
    }

    public static MemberLevelEnum getEnumByCode(Integer code) {
        for (MemberLevelEnum e : MemberLevelEnum.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        return null;
    }

    public String getMessageImage() {
        return this.messageImage;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public BigDecimal getThreshold() {
        return this.threshold;
    }

    public int getLevel() {
        return this.level;
    }

    public BigDecimal getBdayDiscountRatio() {
        return this.bdayDiscountRatio;
    }

    public String getDescription() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date start = sdf.parse(this.startTime);
            Date end = sdf.parse(this.endTime);
            Date now = new Date();
            if (now.after(start) && now.before(end)) {
                if (this.code == 2) {
                    return "\u8001\u864e\u4f1a\u5458\u4e13\u4eab88\u6298\uff087.31~8.31\uff09";
                }
                if (this.code == 3) {
                    return "\u5927\u8c61\u4f1a\u5458\u4e13\u4eab88\u6298\uff087.31~8.31\uff09";
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this.description;
    }

    public String getBdDescription() {
        return this.bdDescription;
    }

    public String toString() {
        return this.getCode().toString();
    }

    public static int getLevelByCode(int code) {
        MemberLevelEnum memberLevelEnum = MemberLevelEnum.getEnumByCode(code);
        if (memberLevelEnum == null) {
            throw new RuntimeException("\u6ca1\u6709\u8fd9\u4e2a\u4f1a\u5458\u7c7b\u578bID[" + code + "]");
        }
        return memberLevelEnum.getLevel();
    }

    public static MemberLevelEnum getNextLevelEnumByCode(int code) {
        MemberLevelEnum originalLevelEnum = MemberLevelEnum.getEnumByCode(code);
        if (originalLevelEnum == null) {
            throw new RuntimeException("\u6ca1\u6709\u8fd9\u4e2a\u4f1a\u5458\u7c7b\u578bID[" + code + "]");
        }
        MemberLevelEnum nextLevelEnum = Arrays.stream(MemberLevelEnum.values()).filter(memberLevelEnum -> memberLevelEnum.getLevel() > originalLevelEnum.getLevel()).min(Comparator.comparingInt(MemberLevelEnum::getLevel)).orElse(null);
        return nextLevelEnum;
    }

    public static MemberLevelEnum getPreLevelEnumByCode(int code) {
        MemberLevelEnum originalLevelEnum = MemberLevelEnum.getEnumByCode(code);
        if (originalLevelEnum == null) {
            throw new RuntimeException("\u6ca1\u6709\u8fd9\u4e2a\u4f1a\u5458\u7c7b\u578bID[" + code + "]");
        }
        MemberLevelEnum preLevelEnum = Arrays.stream(MemberLevelEnum.values()).filter(memberLevelEnum -> memberLevelEnum.getLevel() < originalLevelEnum.getLevel()).min((o1, o2) -> o2.getLevel() - o1.getLevel()).orElse(null);
        return preLevelEnum;
    }

    public static void main(String[] args) {
        System.out.println(VIP1.getShortName());
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getUpgradeUrl() {
        return this.upgradeUrl;
    }

    static {
        ALL = Collections.unmodifiableList(Arrays.asList(MemberLevelEnum.values()));
    }
}

