package com.thebeastshop.common.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum AccessWayEnum implements CodeEnum<Integer> {
	UNKNOWN(0, "未知", -1),
	PC(1, "PC",1),
	APP(2, "APP",1),
	WAP(3, "WAP",1),
	OFFLINE(4, "MS门店", 0),
    LITTLE_B(5, "Little B门店", 0),
    APPLET(6,"小程序", 1),
    HOME_SHOP(7,"HOME门店", 0),
    TBH_SHOP(8,"TBH门店", 0),
    POP_SHOP(9,"POP门店", 0),
	BLINGBLING_SHOP(10,"BlingBling门店", 0),
	NAKED_SHOP(11,"Naked门店", 0),
	BUTO_SHOP(12,"Buto门店", 0),
	FLAGSHIP_SHOP(13,"旗舰综合店", 0),
	SATELLITE_SHOP(14,"SATELLITE门店", 0),
	INSTORE_APPLET(15,"内购小程序", 1),
	LB_APPLET(16,"TBH小程序", 1),
    OTHER(99,"其它", -1);

	private Integer code;
	private String name;
	private Integer type;

	public static final List<AccessWayEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	AccessWayEnum(Integer code,String name, Integer type) {
		this.code = code;
		this.name = name;
		this.type = type;
	}

	@Override
	public Integer getCode() {
		return code;
	}

	@Override
	public String getName(){
		return name;
	}

	public Integer getType() {
		return type;
	}

	public static AccessWayEnum getEnumByCode(Integer code) {
		for (AccessWayEnum e : AccessWayEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

    public static String getNameByCode(Integer code) {
        AccessWayEnum accessWayEnum = getEnumByCode(code);
        if (accessWayEnum != null){
            return accessWayEnum.getName();
        }
        return "";
    }

	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
