package com.thebeastshop.common.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * ecp推送错误类型
 * Created by Gary on 2017/7/19.
 */
public enum EcpPushErrorTypeEnum {
      NO_ERROR(10, "正常"),
      OTHER_ERROR(-1, "其它异常"),
      SKU_NOT_EXIST(0, "SKU不存在"),
      NOT_ENOUGH_STOCK(1, "库存不足"),
      HMT_ORDER(2, "港澳台订单"),
      TOO_MANY_CUSTOM_SKU(3, "定制商品数量超限"),
      NO_CUSTOM_INFO(4, "获取不到订单定制信息"),
      NO_CUSTOM_STOCK(5, "定制商品材料不足"),
      GARBLED(7, "乱码"),
      EXCEPTION_SHIPPING_ADDRESS(6, "异常详细收货地址"),
      DOUBLE_11_PRESALE(8, "分批预售"),
      DOUBLE_11_LIVE_BROADCAST(9, "特殊链接"),
      CARD_FORMAT_ERROR(11, "贺卡格式错误");

  private int val;

  private String desc;

  public static final List<EcpPushErrorTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(EcpPushErrorTypeEnum.values()));
  EcpPushErrorTypeEnum(int val, String desc) {
      this.val = val;
      this.desc = desc;
  }

  public static  String getDesc(int val) {
    List<EcpPushErrorTypeEnum> all = Arrays.asList(EcpPushErrorTypeEnum.values());
    for (EcpPushErrorTypeEnum errorTypeEnum : all) {
        if(errorTypeEnum.getVal() == val) {
          return  errorTypeEnum.getDesc();
        }
    }
    return  "";
  }
  public int getVal() {
    return val;
  }

  public String getDesc() {
    return desc;
  }
}
