package com.thebeastshop.common.enums;

import com.google.common.collect.Maps;

import java.util.Map;

public enum AccessWayTypeEnum {
    PC(1, "online"),
    APP(2, "online"),
    WAP(3, "online"),
    OFFLINE(4, "offline"),
    LITTLE_B(5, "offline"),
    APPLET(6, "online"),
    HOME_SHOP(7, "offline"),
    TBH_SHOP(8, "offline"),
    POP_SHOP(9, "offline"),
    LINGBLING_SHOP(10,"offline"),
    NAKED_SHOP(11,"offline"),
    BUTO_SHOP(12,"offline"),
    FLAGSHIP_SHOP(13, "offline"),
    SATELLITE_SHOP(14, "offline"),
    INSTORE_APPLET(15, "online"),
    LB_APPLET(16, "online"),
    OTHER(99,"online"),
    ;

    private Integer code;
    private String name;

    private AccessWayTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static AccessWayTypeEnum getEnumByCode(Integer code) {
        AccessWayTypeEnum[] arr$ = values();
        int len$ = arr$.length;

        for(int i$ = 0; i$ < len$; ++i$) {
            AccessWayTypeEnum e = arr$[i$];
            if (e.getCode().equals(code)) {
                return e;
            }
        }

        return null;
    }

    public static Map<String,String> getEnumByCode() {
        Map<String,String> maps = Maps.newHashMap();
        AccessWayTypeEnum[] arr$ = values();
        int len$ = arr$.length;

        for(int i$ = 0; i$ < len$; ++i$) {
            AccessWayTypeEnum e = arr$[i$];
            maps.put(String.valueOf(e.getCode()),e.getName());
        }

        return maps;
    }

    public static boolean checkAccessOnline(Integer code){
        if("online".equals(getNameByCode(code))){
            return true;
        }else{
            return false;
        }
    }
    public static String getNameByCode(Integer code) {
        AccessWayTypeEnum accessWayEnum = getEnumByCode(code);
        return accessWayEnum != null ? accessWayEnum.getName() : "";
    }

    public String toString() {
        return this.getCode().toString();
    }
}
