package com.thebeastshop.common.enums;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public enum MemberLevelEnum implements CodeEnum<Integer> {
	NORMAL(-1, "注册用户", new BigDecimal("1.00"), "http://img.thebeastshop.com/app/message/member_icon0.png", "member/privilege/level-icon/level-zero.jpg", new BigDecimal("0.00"), null, null),
	VIP(0, "松鼠会员", new BigDecimal("1.00"), "http://img.thebeastshop.com/app/message/member_icon1.png", "member/privilege/level-icon/level-one.jpg", new BigDecimal("0.01"), null, "您已享受松鼠会员生日9.5折"),
	VIP2(1, "小猫会员", new BigDecimal("0.95"), "http://img.thebeastshop.com/app/message/member_icon2.png", "member/privilege/level-icon/level-two.jpg", new BigDecimal("5000.00"), "您已享受小猫会员折扣9.5折", "您已享受小猫会员生日9折"),
	VIP3(2, "老虎会员", new BigDecimal("0.90"), "http://img.thebeastshop.com/app/message/member_icon4.png", "member/privilege/level-icon/level-three.jpg", new BigDecimal("10000.00"), "您已享受老虎会员折扣9折", "您已享受老虎会员生日8.5折"),
	VIP4(3, "大象会员", new BigDecimal("0.90"), "http://img.thebeastshop.com/app/message/member_icon3.png", "member/privilege/level-icon/level-four.jpg", new BigDecimal("50000.00"), "您已享受大象会员折扣9折", "您已享受大象会员生日8折"),;

	private final int code;
	private final String name;
	private final BigDecimal levelAmountCondition;
	private final String messageImage;
	private final String avatarUrl;
	private final BigDecimal threshold;
	private final String description;
	private final String bdDescription;

	private String startTime = "2017-07-31 00:00:00";
	private String endTime = "2017-08-31 23:59:59";

	public static final List<MemberLevelEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private MemberLevelEnum(int code, String name, BigDecimal levelAmountCondition, String messageImage, String avatarUrl, BigDecimal threshold, String description, String bdDescription) {
		this.code = code;
		this.name = name;
		this.levelAmountCondition = levelAmountCondition;
		this.avatarUrl = "http://img.thebeastshop.com/" + avatarUrl;
		this.messageImage = messageImage;
		this.threshold = threshold;
		this.description = description;
		this.bdDescription = bdDescription;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	public BigDecimal getLevelAmountCondition() {

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			Date start = sdf.parse(startTime);
			Date end = sdf.parse(endTime);
			Date now = new Date();
			if (now.after(start) && now.before(end)) {
				if (levelAmountCondition.equals(new BigDecimal("0.90")))
					return new BigDecimal("0.88");
			}

		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return levelAmountCondition;
	}

	public static MemberLevelEnum getEnumByCode(Integer code) {
		for (MemberLevelEnum e : MemberLevelEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

	public String getMessageImage() {
		return messageImage;
	}

	public String getAvatarUrl() {
		return avatarUrl;
	}

	public BigDecimal getThreshold() {
		return threshold;
	}

	public String getDescription() {

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			Date start = sdf.parse(startTime);
			Date end = sdf.parse(endTime);
			Date now = new Date();
			if (now.after(start) && now.before(end)) {
				if (code == 2) {
					return "老虎会员专享88折（7.31~8.31）";
				}
				if (code == 3) {
					return "大象会员专享88折（7.31~8.31）";
				}
			}

		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return description;
	}

	public String getBdDescription() {
		return bdDescription;
	}

	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
