package com.thebeastshop.common.enums;


/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2018-04-17 11:25
 */
public enum ActiveEnum implements CodeEnum<Integer>, BooleanValue {
    ACTIVE(1, "有效"),
    INACTIVE(0, "无效"),
    ;
    private Integer code;
    private String name;

    ActiveEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    @Override
    public Integer getCode() {
        return code;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Boolean toBooleanValue() {
        return code == 0 ? false : true;
    }
}
