package com.thebeastshop.kit.dubbo;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.spring.AnnotationBean;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;


@Configuration
@EnableConfigurationProperties({DubboProperty.class})
public class DubboConfig {

    @Bean
    @ConditionalOnMissingBean
    public DubboProperty dubboProperty() {
        return new DubboProperty();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty("dubbo.application")
    public ApplicationConfig applicationConfig(DubboProperty dubboProperty) {
        ApplicationConfig applicationConfig = new ApplicationConfig();
        applicationConfig.setName(dubboProperty.getApplication());
        return applicationConfig;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty("dubbo.address")
    public RegistryConfig registryConfig(DubboProperty dubboProperty) {
        RegistryConfig registryConfig = new RegistryConfig();
        registryConfig.setAddress(dubboProperty.getAddress());
        String group = dubboProperty.getGroup();
        if (StringUtils.isNoneBlank(group)) {
            registryConfig.setGroup(group.trim());
        }
        String version = dubboProperty.getVersion();
        if (StringUtils.isNoneBlank(version)) {
            registryConfig.setVersion(version.trim());
        }
        registryConfig.setTimeout(100000);
        DubboCacheProperties cacheProperties = dubboProperty.getCache();
        if (cacheProperties != null) {
            String filepath = cacheProperties.getFilepath();
            if (StringUtils.isNoneBlank(filepath)) {
                registryConfig.setFile(filepath);
            }
        }
        return registryConfig;
    }

    @Bean
    @ConditionalOnMissingBean
    public AnnotationBean annotationBean(BeanFactory beanFactory) {
        AnnotationBean annotationBean = new AnnotationBean();
        List<String> pkgs = AutoConfigurationPackages.get(beanFactory);
        if (pkgs != null && pkgs.size() > 0) {
            annotationBean.setPackage(pkgs.get(0));
        }
        return annotationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public ProtocolConfig protocolConfig(DubboProperty dubboProperty) {
        ProtocolConfig protocolConfig = new ProtocolConfig();
        protocolConfig.setName("dubbo");
        Integer port = dubboProperty.getPort();
        if (port != null) {
            protocolConfig.setPort(port);
        }
        Integer threads = dubboProperty.getThreads();
        threads = threads == null ? 200 : threads;
        protocolConfig.setThreads(threads);
        return protocolConfig;
    }



}
