/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.db.aop;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.StrUtil;
import com.thebeastshop.kit.db.anno.ForceDB;
import com.thebeastshop.kit.db.manager.ForceDBManager;
import com.thebeastshop.kit.db.utils.MethodHelper;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class ForceDBAspect {
    private Map<String, ForceDB> annoCacheMap = new ConcurrentHashMap<String, ForceDB>();

    @Pointcut(value="@annotation(com.thebeastshop.kit.db.anno.ForceDB)")
    public void cut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="cut()")
    public Object around(ProceedingJoinPoint jp) throws Throwable {
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Class<?> clazz = jp.getTarget().getClass();
        Method m = signature.getMethod();
        String key = StrUtil.format((CharSequence)"{}.{}", (Object[])new Object[]{clazz.getName(), MethodHelper.resolveMethodName(m)});
        ForceDB forceDB = this.annoCacheMap.containsKey(key) ? this.annoCacheMap.get(key) : (ForceDB)AnnotationUtil.getAnnotation((AnnotatedElement)m, ForceDB.class);
        if (forceDB != null) {
            ForceDBManager.setForceDB(forceDB);
            this.annoCacheMap.putIfAbsent(key, forceDB);
        }
        try {
            Object object = jp.proceed();
            return object;
        }
        finally {
            ForceDBManager.clearForceDB();
        }
    }
}

