package com.thebeastshop.kit.db.aop;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.StrUtil;
import com.thebeastshop.kit.db.anno.ForceDB;
import com.thebeastshop.kit.db.manager.ForceDBManager;
import com.thebeastshop.kit.db.utils.MethodHelper;
import org.apache.commons.beanutils.MethodUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Aspect
public class ForceDBAspect {

    private Map<String, ForceDB> annoCacheMap = new ConcurrentHashMap<>();

    @Pointcut("@annotation(com.thebeastshop.kit.db.anno.ForceDB)")
    public void cut(){}

    @Around("cut()")
    public Object around(ProceedingJoinPoint jp) throws Throwable{
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Class clazz = jp.getTarget().getClass();
        Method m = signature.getMethod();
        String key = StrUtil.format("{}.{}", clazz.getName(), MethodHelper.resolveMethodName(m));
        ForceDB forceDB;
        if (annoCacheMap.containsKey(key)){
            forceDB = annoCacheMap.get(key);
        }else{
            forceDB = AnnotationUtil.getAnnotation(m, ForceDB.class);
        }

        if (forceDB != null){
            ForceDBManager.setForceDB(forceDB);
            annoCacheMap.putIfAbsent(key, forceDB);
        }

        try{
            return jp.proceed();
        }finally {
            ForceDBManager.clearForceDB();
        }
    }
}
