/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.kit.codetemplate.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * CODE 生成器
 *
 * @author gongjun
 */
public class CodeGenerator {

    private final Logger log = LoggerFactory.getLogger(CodeGenerator.class);

    private static CodeGenerator instance;

    private Configuration cfg = new Configuration();

    // 缓存内容
    private Map<String, Template> __cachedTemplateMap = new ConcurrentHashMap<String, Template>();

    private CodeGenerator() {
    }

    public void addCodeTemplate(String codeTemplateName, String source) {
        try {
            Template tpl = new Template(codeTemplateName, source, cfg);
            __cachedTemplateMap.put(codeTemplateName, tpl);
        } catch (IOException e) {
            throw new RuntimeException("创建code模板失败", e);
        }
    }

    public static CodeGenerator getInstance() {
        if (instance != null) {
            return instance;
        }
        synchronized (CodeGenerator.class) {
            if (instance == null) {
                instance = new CodeGenerator();
            }
        }
        return instance;
    }

    /**
     * 生成CODE
     *
     * @param codeTemplateName CODE模板名
     * @param params           参数
     * @return CODE
     */
    public String generate(String codeTemplateName, Map<String, Object> params) {
        String result;
        Template tpl = __cachedTemplateMap.get(codeTemplateName);
        if (tpl == null) {
            throw new IllegalArgumentException("can't find template for name : " + codeTemplateName);
        } else {
            StringWriter sw = new StringWriter();
            try {
                tpl.process(params, sw);
                result = sw.toString().toUpperCase();
            } catch (Exception e) {
                log.warn("", e);
                throw new RuntimeException("CodeGenerator.generate failed : " + codeTemplateName + " : " + params);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        CodeGenerator.getInstance().addCodeTemplate("abc","这是一个模板,模板的名字为:${name}");
        Map<String,Object> map = new HashMap<>();
        map.put("name","简单模板");
        String str = CodeGenerator.getInstance().generate("abc",map);
        System.out.println(str);
    }

}
