/*
 * Decompiled with CFR 0.152.
 */
package com.thebeast.kit.alitool;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.sts.AssumeRoleRequest;
import com.aliyuncs.auth.sts.AssumeRoleResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.thebeast.kit.alitool.OSSSecurityResp;

public class OSSSecurityClient {
    public static final String REGION_CN_HANGZHOU = "cn-hangzhou";
    public static final String STS_API_VERSION = "2015-04-01";
    public static final String roleSessionName = "beast";
    public static final String policy = "{\n  \"Statement\": [\n    {\n      \"Action\": [\n        \"oss:*\"\n      ],\n      \"Effect\": \"Allow\",\n      \"Resource\": [\"acs:oss:*:*:*\"]\n    }\n  ],\n  \"Version\": \"1\"\n}\n";
    private String ossSecurityAccessId;
    private String ossSecurityAccessKey;
    private String ossSecurityRoleArn;

    public String getOssSecurityAccessId() {
        return this.ossSecurityAccessId;
    }

    public void setOssSecurityAccessId(String ossSecurityAccessId) {
        this.ossSecurityAccessId = ossSecurityAccessId;
    }

    public String getOssSecurityAccessKey() {
        return this.ossSecurityAccessKey;
    }

    public void setOssSecurityAccessKey(String ossSecurityAccessKey) {
        this.ossSecurityAccessKey = ossSecurityAccessKey;
    }

    public String getOssSecurityRoleArn() {
        return this.ossSecurityRoleArn;
    }

    public void setOssSecurityRoleArn(String ossSecurityRoleArn) {
        this.ossSecurityRoleArn = ossSecurityRoleArn;
    }

    public OSSSecurityResp getSecurityToken(Long durationSeconds) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile((String)REGION_CN_HANGZHOU, (String)this.ossSecurityAccessId, (String)this.ossSecurityAccessKey);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        AssumeRoleRequest request = new AssumeRoleRequest();
        request.setVersion(STS_API_VERSION);
        request.setMethod(MethodType.POST);
        request.setProtocol(ProtocolType.HTTPS);
        request.setRoleArn(this.ossSecurityRoleArn);
        request.setRoleSessionName(roleSessionName);
        request.setPolicy(policy);
        request.setDurationSeconds(durationSeconds);
        AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
        OSSSecurityResp ossSecurityResp = new OSSSecurityResp();
        ossSecurityResp.setAccessKeyId(response.getCredentials().getAccessKeyId());
        ossSecurityResp.setAccessKeySecret(response.getCredentials().getAccessKeySecret());
        ossSecurityResp.setExpiration(response.getCredentials().getExpiration());
        ossSecurityResp.setStatusCode(200);
        ossSecurityResp.setSecurityToken(response.getCredentials().getSecurityToken());
        return ossSecurityResp;
    }
}

