package com.thebeastshop.kit.actuator.dubbo.checker.config;

import com.alibaba.dubbo.config.ServiceConfig;
import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerService;
import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerServiceImpl;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;


public class DubboCheckProviderInit implements InitializingBean {

    private DubboCheckerService ref = new DubboCheckerServiceImpl();

    @Autowired
    private DubboMetaBeanGetter dubboMetaBeanGetter;

    @Override
    public void afterPropertiesSet() {
        ServiceConfig<DubboCheckerService> service = new ServiceConfig<>();
        service.setApplication(dubboMetaBeanGetter.getApplicationConfig());
        service.setRegistry(dubboMetaBeanGetter.getRegistryConfig());
        service.setProtocol(dubboMetaBeanGetter.getProtocolConfig());
        service.setInterface(DubboCheckerService.class);
        service.setScope("local");
        service.setRef(ref);
        service.export();
    }
}
