package com.thebeastshop.kit.actuator.dubbo.autoconfigure;

import com.sun.org.apache.xerces.internal.impl.dv.dtd.ENTITYDatatypeValidator;
import com.thebeastshop.kit.actuator.config.ActuatorPortInit;
import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerService;
import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerServiceImpl;
import com.thebeastshop.kit.actuator.dubbo.checker.config.DubboCheckConsumerFactoryBean;
import com.thebeastshop.kit.actuator.dubbo.checker.config.DubboCheckProviderInit;
import com.thebeastshop.kit.actuator.dubbo.checker.config.DubboMetaBeanGetter;
import com.thebeastshop.kit.actuator.dubbo.health.biz.DubboHealthBizData;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

@Configuration
@ConditionalOnBean(com.alibaba.dubbo.config.RegistryConfig.class)
public class DubboCheckerAutoConfiguration {

    private static Map<String, String> ENV_MAP = new HashMap<>();
    static {
        ENV_MAP.put("local", "local");
        ENV_MAP.put("fat", "test");
        ENV_MAP.put("uat", "pre");
        ENV_MAP.put("pro", "prod");
    }

    @Bean
    public ActuatorPortInit actuatorPortInit(ManagementServerProperties managementServerProperties) {
        return new ActuatorPortInit(managementServerProperties);
    }

    @Bean
    public MeterRegistryCustomizer<MeterRegistry> metricsCommonTags(Environment environment, MeterRegistry registry) {
        String appId = environment.getProperty("app.id");
        if (StringUtils.isBlank(appId)) {
            throw new RuntimeException("[beast-kit-actuator] App ID does not exist!");
        }
        DubboHealthBizData.setRegistry(registry);

        String env = environment.getProperty("env");

        return r -> {
            try {
                r.config().commonTags("application", appId);
                if (StringUtils.isNotBlank(env)) {
                    r.config().commonTags("env", ENV_MAP.get(env));
                }
                InetAddress inetAddress = InetAddress.getLocalHost();
                r.config().commonTags("hostname",inetAddress.getHostName());
            } catch (UnknownHostException e) {
                e.printStackTrace();
            }
        };
    }

    @Bean
    public DubboMetaBeanGetter dubboMetaBeanGetter(ActuatorPortInit actuatorPortInit) {
        return new DubboMetaBeanGetter();
    }

    @Bean
    public DubboCheckProviderInit checkProviderInit(DubboMetaBeanGetter dubboMetaBeanGetter) {
        return new DubboCheckProviderInit();
    }

    public DubboCheckConsumerFactoryBean dubboCheckConsumerFactoryBean(DubboCheckProviderInit dubboCheckProviderInit,
                                                                       DubboMetaBeanGetter dubboMetaBeanGetter) {
        return new DubboCheckConsumerFactoryBean();
    }
}
