package com.thebeastshop.kit.actuator.dubbo.checker.config;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.thebeastshop.kit.actuator.config.ActuatorPortInit;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.net.InetAddress;
import java.util.Map;

public class DubboMetaBeanGetter implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationConfig getApplicationConfig() {
        return applicationContext.getBean(ApplicationConfig.class);
    }

    public RegistryConfig getRegistryConfig() {
        RegistryConfig registry = null;
        Map<String, RegistryConfig> registryMap = applicationContext.getBeansOfType(RegistryConfig.class);
        if (registryMap.isEmpty()) {
            throw new RuntimeException("[beast-kit-actuator] there is no registry found in this application");
        }
        if (registryMap.size() == 1) {
            registry = registryMap.entrySet().iterator().next().getValue();
        } else {
            for (RegistryConfig regConfig : registryMap.values()) {
                if (regConfig.isDefault()) {
                    registry = regConfig;
                    break;
                }
            }
        }
        if (registry == null) {
            throw new RuntimeException("[beast-kit-actuator] there is no default registry found in this application");
        }
        return registry;
    }

    public ProtocolConfig getProtocolConfig() {
        return applicationContext.getBean(ProtocolConfig.class);
    }

    public String getUniqueNodeStr() {
        InetAddress ia = null;
        try {
            ia = ia.getLocalHost();
            String localip = ia.getHostAddress();
            int port = ActuatorPortInit.actuatorPort;

            String result = localip + "." + port;
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

}
