/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.sdk.config;

import com.thebeastshop.dts.sdk.config.BeastConfigInfo;
import com.thebeastshop.dts.sdk.config.ConfigInfo;
import com.thebeastshop.dts.sdk.config.ExternalConfigInfo;
import org.springframework.core.env.Environment;

public class Config {
    private static ConfigInfo configInfo;
    private static final String BEAST_PROP_CONSTANTS_CLASS = "com.thebeastshop.kit.prop.PropConstants";
    public static final String ENV_LOCAL = "local";
    public static final String ENV_TEST = "test";
    public static final String ENV_PRE = "pre";
    public static final String ENV_FAT = "fat";
    public static final String ENV_uat = "uat";
    public static final String ENV_PROD = "prod";
    public static final String ENV_PRO = "pro";

    public static ConfigInfo loadConfig(Environment environment) {
        Class<?> beastPropConstantsClass = null;
        try {
            beastPropConstantsClass = Class.forName(BEAST_PROP_CONSTANTS_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (beastPropConstantsClass != null) {
            Class<?> beastConfigInfoClass = null;
            try {
                beastConfigInfoClass = Class.forName("com.thebeastshop.dts.sdk.config.BeastConfigInfo");
                try {
                    return (ConfigInfo)beastConfigInfoClass.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return new BeastConfigInfo();
        }
        return new ExternalConfigInfo(environment);
    }

    public static String getAppId() {
        return configInfo.getAppId();
    }

    public static String getEnv() {
        return configInfo.getEnv();
    }

    public static String getProperties(String key) {
        return configInfo.getProperty(key);
    }
}

