/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.sdk;

import com.thebeastshop.dts.sdk.annotation.DTSTable;
import com.thebeastshop.dts.sdk.handler.DTSHandler;
import com.thebeastshop.dts.vo.RegisterInfo;
import com.thebeastshop.dts.vo.RegisterItem;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTSHandlerManager {
    private static Logger log = LoggerFactory.getLogger(DTSHandlerManager.class);
    private static final Map<String, DTSHandler> handlerMap = new HashMap<String, DTSHandler>();

    public static void addHandler(DTSHandler handler) {
        String tableName = handler.getClass().getAnnotation(DTSTable.class).value();
        handlerMap.put(tableName, handler);
    }

    public static DTSHandler getHandler(String tableName) {
        if (handlerMap.containsKey(tableName)) {
            return handlerMap.get(tableName);
        }
        for (Map.Entry<String, DTSHandler> entry : handlerMap.entrySet()) {
            String[] regArray;
            for (String reg : regArray = entry.getKey().split("[ \t\n\r]*,[ \t\n\r]*")) {
                boolean flag = Pattern.matches(reg, tableName);
                if (!flag) continue;
                return handlerMap.get(entry.getKey());
            }
        }
        return null;
    }

    public static Map<String, DTSHandler> getHandlerMap() {
        return handlerMap;
    }

    public static void refreshHandlerConfig(RegisterInfo registerInfo) {
        for (DTSHandler handler : handlerMap.values()) {
            handler.clearRegisterItems();
        }
        for (RegisterItem item : registerInfo.getRegisterItems()) {
            DTSHandler handler = DTSHandlerManager.getHandler(item.getTableName());
            if (handler == null) continue;
            handler.addRegisterItem(item);
        }
    }
}

