/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dc.api.primary;

import com.thebeastshop.dc.api.dto.DcJoinDTO;
import com.thebeastshop.dc.api.dto.DcParamDTO;
import com.thebeastshop.dc.api.dto.DcQueryDTO;
import com.thebeastshop.dc.api.dto.DcSelectionDTO;
import com.thebeastshop.dc.api.primary.AbstractQuery;
import com.thebeastshop.dc.api.primary.AbstractWhere;
import com.thebeastshop.dc.api.primary.DcGetter;
import com.thebeastshop.dc.api.primary.DcJoinBlock;
import com.thebeastshop.dc.api.primary.DcLambdaWhere;
import com.thebeastshop.dc.api.utils.QueryUtil;
import com.thebeastshop.dc.api.vo.DcTableVO;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;

public final class DcLambdaQuery<TABLE extends DcTableVO>
extends AbstractQuery<DcLambdaQuery<TABLE>, TABLE, DcGetter<TABLE, ?>, Function<DcLambdaQuery<TABLE>, DcLambdaQuery<TABLE>>> {
    private final List<DcJoinBlock> joinList = new ArrayList<DcJoinBlock>();

    public DcLambdaQuery(Class<TABLE> tableClass) {
        super(tableClass);
    }

    @Override
    protected DcLambdaQuery<TABLE> newSelfInstance() {
        return new DcLambdaQuery<TABLE>(this.tableClass);
    }

    @Override
    protected <T extends DcTableVO> AbstractWhere createWhere(Class<T> tableClass) {
        this.resetConditionStack();
        return new DcLambdaWhere<T>(tableClass);
    }

    @Override
    public <OTHER_TABLE extends DcTableVO, JOIN extends DcLambdaWhere<OTHER_TABLE>> DcLambdaQuery<TABLE> join(Class<OTHER_TABLE> tableClass, Function<JOIN, JOIN> join) {
        this.resetConditionStack();
        this.joinList.add(new DcJoinBlock<OTHER_TABLE>(tableClass, join));
        return (DcLambdaQuery)this.self;
    }

    @Override
    public DcQueryDTO toDTO() {
        DcQueryDTO dto = super.toDTO();
        DcSelectionDTO select = dto.getSelect();
        DcSelectionDTO selectionDTO = new DcSelectionDTO();
        if (select != null && CollectionUtils.isNotEmpty(select.getIncludes())) {
            selectionDTO.addIncludeColumns(dto.getSelect().getIncludes());
        }
        if (select != null && CollectionUtils.isNotEmpty(select.getExcludes())) {
            selectionDTO.addExcludeColumns(dto.getSelect().getExcludes());
        }
        if (CollectionUtils.isNotEmpty(selectionDTO.getIncludes()) || CollectionUtils.isNotEmpty(selectionDTO.getExcludes())) {
            dto.setSelect(selectionDTO);
        }
        for (DcJoinBlock joinBlock : this.joinList) {
            Class tableClass = joinBlock.getTableClass();
            AbstractWhere joinWhere = this.createWhere(tableClass);
            Object ret = joinBlock.getBlock().apply(joinWhere);
            if (ret != null && ret instanceof DcLambdaQuery) {
                joinWhere = (DcLambdaWhere)ret;
            }
            DcQueryDTO joinQueryDTO = joinWhere.getQuery().toDTO();
            if (dto.getCond().getAnd() == null) {
                dto.getCond().setAnd(new LinkedList<DcParamDTO>());
            }
            boolean isFlattened = QueryUtil.isFlattened(tableClass);
            DcJoinDTO joinDTO = new DcJoinDTO();
            joinDTO.setFlattened(isFlattened);
            joinDTO.setPath(isFlattened ? QueryUtil.getJoinPath(tableClass) : QueryUtil.getNestedPath(tableClass));
            joinDTO.setJoin(joinQueryDTO.getCond());
            dto.getCond().addAnd(joinDTO);
        }
        return dto;
    }
}

