/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dc.api.primary;

import cn.hutool.core.util.StrUtil;
import com.thebeastshop.dc.api.primary.DcConditionStackFrame;
import com.thebeastshop.dc.api.primary.DcQuery;
import com.thebeastshop.dc.api.primary.DcWhere;
import com.thebeastshop.dc.api.vo.DcTableVO;
import java.util.Collection;
import java.util.Stack;
import java.util.function.Consumer;

public abstract class AbstractWhere<SELF extends AbstractWhere, TABLE extends DcTableVO, COLUMN, QUERY extends DcQuery, BLOCK>
implements DcWhere<SELF, TABLE, COLUMN, BLOCK> {
    protected final SELF self = this;
    protected final QUERY query;
    private final Stack<DcConditionStackFrame> conditionStack = new Stack();

    protected AbstractWhere(QUERY query) {
        this.query = query;
    }

    protected abstract <T extends DcTableVO> AbstractWhere createWhere(Class<T> var1);

    @Override
    public SELF eq(COLUMN column, Object value) {
        this.resetConditionStack();
        this.query.eq(column, value);
        return this.self;
    }

    @Override
    public SELF ne(COLUMN column, Object value) {
        this.resetConditionStack();
        this.query.ne(column, value);
        return this.self;
    }

    @Override
    public SELF gt(COLUMN column, Object value) {
        this.resetConditionStack();
        this.query.gt(column, value);
        return this.self;
    }

    @Override
    public SELF ge(COLUMN column, Object value) {
        this.resetConditionStack();
        this.query.ge(column, value);
        return this.self;
    }

    @Override
    public SELF lt(COLUMN column, Object value) {
        this.resetConditionStack();
        this.query.lt(column, value);
        return this.self;
    }

    @Override
    public SELF le(COLUMN column, Object value) {
        this.resetConditionStack();
        this.query.le(column, value);
        return this.self;
    }

    @Override
    public SELF in(COLUMN column, Object ... values) {
        this.resetConditionStack();
        this.query.in(column, values);
        return this.self;
    }

    @Override
    public SELF in(COLUMN column, Collection values) {
        this.resetConditionStack();
        this.query.in(column, values);
        return this.self;
    }

    @Override
    public SELF exists(COLUMN column) {
        this.resetConditionStack();
        this.query.exists(column);
        return this.self;
    }

    @Override
    public SELF match(COLUMN column, Object value) {
        this.resetConditionStack();
        this.query.match(column, value);
        return this.self;
    }

    @Override
    public SELF match(COLUMN column, String text, Object ... params) {
        this.resetConditionStack();
        this.query.match(column, StrUtil.format((CharSequence)text, (Object[])params));
        return this.self;
    }

    @Override
    public SELF matchPrefix(COLUMN column, Object value) {
        this.resetConditionStack();
        this.query.matchPrefix(column, value);
        return this.self;
    }

    @Override
    public SELF like(COLUMN column, Object value) {
        this.resetConditionStack();
        this.query.like(column, value);
        return this.self;
    }

    @Override
    public SELF like(COLUMN column, String text, Object ... params) {
        this.resetConditionStack();
        this.query.like(column, StrUtil.format((CharSequence)text, (Object[])params));
        return this.self;
    }

    @Override
    public SELF notMatch(COLUMN column, Object value) {
        this.resetConditionStack();
        this.query.notMatch(column, value);
        return this.self;
    }

    @Override
    public SELF notMatch(COLUMN column, String text, Object ... params) {
        this.resetConditionStack();
        this.query.notMatch(column, StrUtil.format((CharSequence)text, (Object[])params));
        return this.self;
    }

    @Override
    public SELF notMatchPrefix(COLUMN column, Object value) {
        this.resetConditionStack();
        this.query.notMatchPrefix(column, value);
        return this.self;
    }

    @Override
    public SELF notIn(COLUMN column, Object ... values) {
        this.resetConditionStack();
        this.query.notIn(column, values);
        return this.self;
    }

    @Override
    public SELF notExists(COLUMN column) {
        this.resetConditionStack();
        this.query.notExists(column);
        return this.self;
    }

    @Override
    public final SELF not(BLOCK condition) {
        this.resetConditionStack();
        this.query.not(condition);
        return this.self;
    }

    @Override
    public SELF and(BLOCK ... conditions) {
        this.resetConditionStack();
        this.query.and(conditions);
        return this.self;
    }

    @Override
    @SafeVarargs
    public final SELF or(BLOCK ... conditions) {
        this.resetConditionStack();
        this.query.or(conditions);
        return this.self;
    }

    public QUERY getQuery() {
        return this.query;
    }

    private DcConditionStackFrame getAndCheckCurrentConditionStackFrame() {
        if (this.conditionStack.isEmpty()) {
            throw new RuntimeException("Can not use elseCond() or elseThen(), because cond() has never been called before");
        }
        DcConditionStackFrame frame = this.conditionStack.peek();
        if (frame == null) {
            throw new RuntimeException("Can not use elseCond() or elseThen(), because cond() has never been called before");
        }
        return frame;
    }

    protected void resetConditionStack() {
        if (!this.conditionStack.isEmpty()) {
            DcConditionStackFrame frame = this.conditionStack.peek();
            frame.setLastCondition(null);
        }
    }

    @Override
    public SELF cond(boolean condition, Consumer<SELF> q) {
        DcConditionStackFrame frame;
        if (this.conditionStack.isEmpty()) {
            frame = new DcConditionStackFrame();
            this.conditionStack.push(frame);
        } else {
            frame = this.conditionStack.peek();
        }
        frame.setLastCondition(condition);
        if (condition) {
            this.conditionStack.push(new DcConditionStackFrame());
            q.accept(this.self);
            this.conditionStack.pop();
        }
        return this.self;
    }

    @Override
    public SELF elseCond(boolean condition, Consumer<SELF> q) {
        DcConditionStackFrame frame = this.getAndCheckCurrentConditionStackFrame();
        boolean lastCondition = frame.getLastCondition();
        frame.setLastCondition(condition);
        if (!lastCondition && condition) {
            this.conditionStack.push(new DcConditionStackFrame());
            q.accept(this.self);
            this.conditionStack.pop();
        }
        return this.self;
    }

    @Override
    public SELF elseThen(Consumer<SELF> q) {
        DcConditionStackFrame frame = this.getAndCheckCurrentConditionStackFrame();
        boolean lastCondition = frame.getLastCondition();
        if (!lastCondition) {
            this.conditionStack.push(new DcConditionStackFrame());
            q.accept(this.self);
            this.conditionStack.pop();
        }
        this.resetConditionStack();
        return this.self;
    }
}

