/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dc.api.primary;

import com.thebeastshop.dc.api.primary.DcOp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DcParam {
    public static final Map<DcOp, DcOp> NEGATIVE_POSITIVE_OP_MAP = new HashMap<DcOp, DcOp>();
    public static final Set<DcOp> MATCH_OP_MAP = new HashSet<DcOp>();
    protected DcOp op;
    protected Object value;

    public DcParam(DcOp type, Object value) {
        this.op = type;
        this.value = value;
    }

    public DcOp getOp() {
        return this.op;
    }

    public boolean isNegative() {
        return NEGATIVE_POSITIVE_OP_MAP.get((Object)this.op) != null;
    }

    public boolean isMatch() {
        return MATCH_OP_MAP.contains((Object)this.op);
    }

    public void setOp(DcOp op) {
        this.op = op;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(List<?> value) {
        this.value = value;
    }

    static {
        NEGATIVE_POSITIVE_OP_MAP.put(DcOp.NE, DcOp.EQ);
        NEGATIVE_POSITIVE_OP_MAP.put(DcOp.NOT_IN, DcOp.IN);
        NEGATIVE_POSITIVE_OP_MAP.put(DcOp.NOT_EXISTS, DcOp.EXISTS);
        NEGATIVE_POSITIVE_OP_MAP.put(DcOp.NOT_LIKE, DcOp.LIKE);
        NEGATIVE_POSITIVE_OP_MAP.put(DcOp.NOT_MATCH, DcOp.MATCH);
        NEGATIVE_POSITIVE_OP_MAP.put(DcOp.NOT_MATCH_PREFIX, DcOp.MATCH_PREFIX);
        MATCH_OP_MAP.add(DcOp.MATCH);
        MATCH_OP_MAP.add(DcOp.MATCH_PREFIX);
    }
}

