/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dc.api.primary;

import com.thebeastshop.dc.api.dto.DcJoinDTO;
import com.thebeastshop.dc.api.dto.DcParamDTO;
import com.thebeastshop.dc.api.dto.DcQueryDTO;
import com.thebeastshop.dc.api.primary.AbstractQuery;
import com.thebeastshop.dc.api.primary.AbstractWhere;
import com.thebeastshop.dc.api.primary.DcGetter;
import com.thebeastshop.dc.api.primary.DcJoinBlock;
import com.thebeastshop.dc.api.primary.DcLambdaWhere;
import com.thebeastshop.dc.api.utils.QueryUtil;
import com.thebeastshop.dc.api.vo.DcTableVO;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public final class DcLambdaQuery<TABLE extends DcTableVO>
extends AbstractQuery<DcLambdaQuery<TABLE>, TABLE, DcGetter<TABLE, ?>> {
    private final List<DcJoinBlock> joinList = new LinkedList<DcJoinBlock>();

    public DcLambdaQuery(Class<TABLE> tableClass) {
        super(tableClass);
    }

    @Override
    protected <T extends DcTableVO> AbstractWhere createWhere(Class<T> tableClass) {
        return new DcLambdaWhere<T>(tableClass);
    }

    @Override
    public <OTHER_TABLE extends DcTableVO, JOIN extends DcLambdaWhere<OTHER_TABLE>> DcLambdaQuery<TABLE> join(Class<OTHER_TABLE> tableClass, Function<JOIN, JOIN> join) {
        this.joinList.add(new DcJoinBlock<OTHER_TABLE>(tableClass, join));
        return (DcLambdaQuery)this.self;
    }

    @Override
    public DcQueryDTO toDTO() {
        DcQueryDTO dto = super.toDTO();
        for (DcJoinBlock joinBlock : this.joinList) {
            Class tableClass = joinBlock.getTableClass();
            AbstractWhere joinWhere = this.createWhere(tableClass);
            Object ret = joinBlock.getBlock().apply(joinWhere);
            if (ret != null && ret instanceof DcLambdaQuery) {
                joinWhere = (DcLambdaWhere)ret;
            }
            DcQueryDTO joinQueryDTO = joinWhere.getQuery().toDTO();
            if (dto.getCond().getAnd() == null) {
                dto.getCond().setAnd(new LinkedList<DcParamDTO>());
            }
            String path = QueryUtil.getJoinPath(joinBlock.getTableClass());
            DcJoinDTO joinDTO = new DcJoinDTO();
            joinDTO.setPath(path);
            joinDTO.setJoin(joinQueryDTO.getCond());
            dto.getCond().addAnd(joinDTO);
        }
        return dto;
    }
}

