/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dc.api.primary;

import com.thebeastshop.dc.api.dto.DcAggDTO;
import com.thebeastshop.dc.api.dto.DcMetricsDTO;
import com.thebeastshop.dc.api.primary.DcAgg;
import com.thebeastshop.dc.api.primary.DcMetrics;
import com.thebeastshop.dc.api.primary.DcMetricsType;
import com.thebeastshop.dc.api.utils.QueryUtil;
import com.thebeastshop.dc.api.vo.DcTableVO;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractAgg<SELF extends AbstractAgg<SELF, TABLE, COLUMN>, TABLE extends DcTableVO, COLUMN>
implements DcAgg<SELF, COLUMN> {
    protected final SELF self = this;
    protected final Class<TABLE> tableClass;
    protected Map<DcMetricsType, DcMetrics<COLUMN>> metrics = new LinkedHashMap<DcMetricsType, DcMetrics<COLUMN>>();

    public AbstractAgg(Class<TABLE> tableClass) {
        this.tableClass = tableClass;
    }

    @Override
    public DcAggDTO toDTO() {
        DcAggDTO dto = new DcAggDTO();
        LinkedHashMap<String, DcMetricsDTO> map = new LinkedHashMap<String, DcMetricsDTO>();
        dto.setMetrics(map);
        for (Map.Entry<DcMetricsType, DcMetrics<COLUMN>> entry : this.metrics.entrySet()) {
            DcMetricsType type = entry.getKey();
            DcMetrics<COLUMN> colMetrics = entry.getValue();
            String alias = colMetrics.getAlias();
            DcMetricsDTO metricsDTO = new DcMetricsDTO();
            metricsDTO.setType(type);
            metricsDTO.setAlias(alias);
            metricsDTO.setField(QueryUtil.getColumnName(this.tableClass, colMetrics.getColumn()));
            map.put(alias, metricsDTO);
        }
        return dto;
    }

    private SELF addMetrics(DcMetricsType type, COLUMN column, String alias) {
        this.metrics.put(type, new DcMetrics<COLUMN>(type, column, alias));
        return this.self;
    }

    @Override
    public SELF avg(COLUMN column, String alias) {
        return this.addMetrics(DcMetricsType.AVG, column, alias);
    }

    @Override
    public SELF max(COLUMN column, String alias) {
        return this.addMetrics(DcMetricsType.MAX, column, alias);
    }

    @Override
    public SELF min(COLUMN column, String alias) {
        return this.addMetrics(DcMetricsType.MIN, column, alias);
    }

    @Override
    public SELF count(COLUMN column, String alias) {
        return this.addMetrics(DcMetricsType.COUNT, column, alias);
    }

    @Override
    public SELF sum(COLUMN column, String alias) {
        return this.addMetrics(DcMetricsType.SUM, column, alias);
    }
}

