/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.autoconfiguration;

import com.thebeastshop.datahub.autoconfiguration.common.DatahubProperties;
import com.thebeastshop.datahub.client.DatahubClient;
import com.thebeastshop.datahub.client.impl.KafkaDatahubClient;
import com.thebeastshop.datahub.client.kafka.KafkaDriver;
import com.thebeastshop.datahub.client.kafka.ResponseMessageListener;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration
@ConditionalOnClass(value={KafkaTemplate.class})
@EnableConfigurationProperties(value={DatahubProperties.class})
public class DataHubClientAutoconfiguration {
    @Value(value="${spring.kafka.bootstrap-servers}")
    private String bootstrapServers;
    @Value(value="${spring.kafka.consumer.value-deserializer}")
    private String deserializer;
    private DatahubProperties datahubProperties;

    public DataHubClientAutoconfiguration(DatahubProperties datahubProperties) {
        this.datahubProperties = datahubProperties;
    }

    @Bean
    public KafkaDriver kafkaDriver() {
        KafkaDriver kafkaDriver = new KafkaDriver(this.bootstrapServers, this.deserializer);
        return kafkaDriver;
    }

    @Bean
    public ResponseMessageListener responseMessageListener(KafkaDriver kafkaDriver) {
        ResponseMessageListener listener = new ResponseMessageListener(kafkaDriver);
        return listener;
    }

    @Bean
    @ConditionalOnMissingBean(value={DatahubClient.class})
    public DatahubClient DataHubClient(KafkaTemplate kafkaTemplate, ResponseMessageListener responseMessageListener) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("appId", this.datahubProperties.getAppId());
        properties.put("address", this.datahubProperties.getAddress());
        properties.put("serialization", this.datahubProperties.getSerialization());
        return new KafkaDatahubClient(properties, kafkaTemplate, responseMessageListener);
    }
}

