/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.common.utils;

import com.thebeastshop.datahub.common.enums.MessageOperationEnum;
import com.thebeastshop.datahub.common.enums.MessageProtocolEnum;
import com.thebeastshop.datahub.common.spi.MessageHandlerProvider;
import com.thebeastshop.datahub.common.vo.BusinessMessage;
import com.thebeastshop.datahub.common.vo.Message;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BusinessMessageUtils {
    private static Logger log = LoggerFactory.getLogger(BusinessMessageUtils.class);
    private static final byte VERSION = 1;

    public static <T extends Message> byte[] encode(T message) {
        try {
            short headLength;
            short fullLength = headLength = 3;
            byte[] dataBytes = MessageHandlerProvider.getHandler(message.getProtocol()).serialize2(message);
            ByteBuffer buffer = ByteBuffer.allocate(6 + (fullLength += dataBytes.length));
            buffer.putShort(headLength);
            buffer.putInt(fullLength);
            buffer.put((byte)1);
            buffer.put(message.getOperation().code);
            buffer.put(message.getProtocol().code);
            buffer.put(dataBytes);
            return buffer.array();
        }
        catch (Exception ex) {
            log.error("[DATAHUB] encode error ", (Throwable)ex);
            return null;
        }
    }

    public static <T extends Message> T decode(byte[] bytes, Class<T> clazz) {
        T message = null;
        try {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            short headLength = buffer.getShort();
            int fullLength = buffer.getInt();
            byte version = buffer.get();
            byte operation = buffer.get();
            MessageProtocolEnum protocol = MessageProtocolEnum.getEnumByCode(buffer.get());
            byte[] bs = new byte[fullLength - headLength];
            buffer.get(bs);
            try {
                message = MessageHandlerProvider.getHandler(protocol).deserialize2(bs, clazz);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (message != null) {
                return message;
            }
            if (BusinessMessage.class.isAssignableFrom(clazz)) {
                BusinessMessage msg = new BusinessMessage();
                msg.setOperation(MessageOperationEnum.getEnumByCode(operation));
                msg.setProtocol(protocol);
                msg.setDatas(MessageHandlerProvider.getHandler(protocol).deserialize(bs));
                return (T)msg;
            }
        }
        catch (Exception ex) {
            log.error("[DATAHUB] decode error ", (Throwable)ex);
        }
        return message;
    }
}

