/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.common.spi.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.thebeastshop.datahub.common.enums.MessageProtocolEnum;
import com.thebeastshop.datahub.common.spi.MessageHandler;
import com.thebeastshop.datahub.common.vo.BusinessRecord;
import com.thebeastshop.datahub.common.vo.Message;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoMessageHandler
implements MessageHandler {
    Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public MessageProtocolEnum getProtocol() {
        return MessageProtocolEnum.KRYO;
    }

    @Override
    public byte[] serialize(List<BusinessRecord> datas) {
        byte[] bytes = null;
        try (ByteBufferOutput output = new ByteBufferOutput(1024, -1);){
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            kryo.writeObject((Output)output, datas);
            output.flush();
            bytes = output.toBytes();
        }
        catch (Exception ex) {
            this.log.error("[DATAHUB] [KRYO\u64cd\u4f5c\u5668] \u5e8f\u5217\u5316\u5f02\u5e38", (Throwable)ex);
        }
        return bytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BusinessRecord> deserialize(byte[] data) {
        try (ByteBufferInput input = new ByteBufferInput(data);){
            List record;
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            List list = record = (List)kryo.readObject((Input)input, ArrayList.class);
            return list;
        }
        catch (Exception ex) {
            this.log.error("[DATAHUB] [KRYO\u64cd\u4f5c\u5668] \u53cd\u5e8f\u5217\u5316\u5f02\u5e38", (Throwable)ex);
            return null;
        }
    }

    @Override
    public <T extends Message> byte[] serialize2(T message) {
        byte[] bytes = null;
        try (ByteBufferOutput output = new ByteBufferOutput(1024, -1);){
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            kryo.writeObject((Output)output, message);
            output.flush();
            bytes = output.toBytes();
        }
        catch (Exception ex) {
            this.log.error("[DATAHUB] [KRYO\u64cd\u4f5c\u5668] \u5e8f\u5217\u5316\u5f02\u5e38", (Throwable)ex);
        }
        return bytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends Message> T deserialize2(byte[] data, Class<T> clazz) {
        try (ByteBufferInput input = new ByteBufferInput(data);){
            Message message2;
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            Message message = message2 = (Message)kryo.readObject((Input)input, clazz);
            return (T)message;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

