/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.common.bgel;

import com.thebeastshop.bgel.ast.ASTAccessExpression;
import com.thebeastshop.bgel.ast.ASTBinaryExpression;
import com.thebeastshop.bgel.ast.ASTConstant;
import com.thebeastshop.bgel.ast.ASTDate;
import com.thebeastshop.bgel.ast.ASTExpression;
import com.thebeastshop.bgel.ast.ASTIdentifier;
import com.thebeastshop.bgel.ast.ASTNotExpression;
import com.thebeastshop.bgel.ast.ASTRange;
import com.thebeastshop.bgel.ast.ASTVisitor;
import com.thebeastshop.bgel.runtime.BgelDate;
import com.thebeastshop.bgel.runtime.BgelEvalVisitor;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import com.thebeastshop.bgel.utils.MetaHelper;
import com.thebeastshop.datahub.common.dto.CriteriaNode;
import com.thebeastshop.datahub.common.enums.CriteriaOperatorEnum;
import java.util.LinkedList;
import org.antlr.v4.runtime.Token;

public class DHCriteriaASTVisitor
extends BgelEvalVisitor {
    public void visitIdentifier(BgelRuntimeContext context, ASTIdentifier node) {
        String idName = node.getName();
        context.setResult((Object)idName);
    }

    public void visitAccessExpression(BgelRuntimeContext context, ASTAccessExpression node) {
        ASTExpression leftExpr = node.getLeft();
        leftExpr.visit(context, (ASTVisitor)this);
        ASTExpression left = leftExpr;
        if (!(left instanceof CharSequence) && !(left instanceof ASTIdentifier)) {
            throw new RuntimeException("[DATAHUB] \u8bed\u6cd5\u9519\u8bef\uff1a \u4e0d\u652f\u6301\u8be5\u5b57\u6bb5\u63cf\u8ff0\u65b9\u5f0f'" + node.getText() + "'!");
        }
        String leftName = left.toString();
        if (left instanceof ASTIdentifier) {
            leftName = ((ASTIdentifier)left).getName();
        }
        ASTConstant name = node.getAccessName();
        context.setResult((Object)(leftName + "." + name.getText()));
    }

    public void visitDate(BgelRuntimeContext context, ASTDate node) {
        super.visitDate(context, node);
        BgelDate bgelDate = (BgelDate)context.getResult();
        context.setResult((Object)bgelDate.getDate());
    }

    public void visitRange(BgelRuntimeContext context, ASTRange node) {
        super.visitRange(context, node);
    }

    public void visitNotExpression(BgelRuntimeContext context, ASTNotExpression node) {
        CriteriaNode criteriaNode = new CriteriaNode();
        ASTExpression expression = node.getExpression();
        expression.visit(context, (ASTVisitor)this);
        Object ret = context.getResult();
        if (ret instanceof CriteriaNode) {
            criteriaNode.setOp(CriteriaOperatorEnum.NOT);
            criteriaNode.setValue(ret);
            context.setResult((Object)criteriaNode);
        } else {
            super.visitNotExpression(context, node);
        }
    }

    public void visitBinaryExpression(BgelRuntimeContext context, ASTBinaryExpression node) {
        Token op = node.getOperation();
        int opType = op.getType();
        switch (opType) {
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 37: 
            case 38: {
                CriteriaOperatorEnum criteriaOp = this.transformOp(op);
                ASTExpression leftExpr = node.getLeft();
                ASTExpression rightExpr = node.getRight();
                leftExpr.visit(context, (ASTVisitor)this);
                Object left = context.getResult();
                rightExpr.visit(context, (ASTVisitor)this);
                Object right = context.getResult();
                CriteriaNode criteriaNode = new CriteriaNode();
                criteriaNode.setOp(criteriaOp);
                switch (opType) {
                    case 12: 
                    case 13: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 32: 
                    case 33: 
                    case 37: 
                    case 38: {
                        criteriaNode.setKey(left.toString());
                        criteriaNode.setValue(MetaHelper.unwrap((Object)right));
                    }
                }
                switch (opType) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        LinkedList<CriteriaNode> nodeList = new LinkedList<CriteriaNode>();
                        if (left instanceof CriteriaNode) {
                            if (((CriteriaNode)left).getOp() == criteriaOp) {
                                for (CriteriaNode child : ((CriteriaNode)left).getChildren()) {
                                    nodeList.add(child);
                                }
                            } else {
                                nodeList.add((CriteriaNode)left);
                            }
                        } else {
                            nodeList.add((CriteriaNode)left);
                        }
                        nodeList.add((CriteriaNode)right);
                        criteriaNode.setChildren(nodeList);
                    }
                }
                context.setResult((Object)criteriaNode);
                return;
            }
        }
        super.visitBinaryExpression(context, node);
    }

    private CriteriaOperatorEnum transformOp(Token op) {
        switch (op.getType()) {
            case 22: 
            case 24: {
                return CriteriaOperatorEnum.AND;
            }
            case 23: 
            case 25: {
                return CriteriaOperatorEnum.OR;
            }
            case 14: {
                return CriteriaOperatorEnum.NOT;
            }
            case 13: {
                return CriteriaOperatorEnum.LT;
            }
            case 12: {
                return CriteriaOperatorEnum.GT;
            }
            case 17: {
                return CriteriaOperatorEnum.LE;
            }
            case 16: {
                return CriteriaOperatorEnum.GE;
            }
            case 18: {
                return CriteriaOperatorEnum.EQ;
            }
            case 19: {
                return CriteriaOperatorEnum.NE;
            }
            case 32: {
                return CriteriaOperatorEnum.IN;
            }
            case 33: {
                return CriteriaOperatorEnum.NOT_IN;
            }
            case 37: {
                return CriteriaOperatorEnum.REGEX_MATCH;
            }
            case 38: {
                return CriteriaOperatorEnum.NOT_REGEX_MATCH;
            }
        }
        throw new RuntimeException("[DATAHUB] \u8bed\u6cd5\u9519\u8bef\uff1a \u4e0d\u652f\u6301\u64cd\u4f5c\u7b26'" + op.getText() + "'!");
    }
}

