/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.utils;

import com.thebeastshop.datahub.client.annotation.Business;
import com.thebeastshop.datahub.client.utils.DatahubBeanUtil;
import com.thebeastshop.datahub.client.utils.DatahubMetaClass;
import com.thebeastshop.datahub.client.utils.DatahubProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MetaUtils {
    private MetaUtils() {
    }

    public static Class getAnnotationClass(Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        Class<?> annClass = null;
        if (annotation instanceof Proxy) {
            Class<?>[] interfaces;
            for (Class<?> interfaceClass : interfaces = annotation.getClass().getInterfaces()) {
                if (!interfaceClass.isAnnotation()) continue;
                annClass = interfaceClass;
                break;
            }
            return annClass;
        }
        annClass = annotation.getClass();
        if (annClass.isAnnotation()) {
            return annClass;
        }
        return null;
    }

    public static String getBusinessName(Class businessClass) {
        String cachedName = MetaUtils.getBusinessNameFromCache(businessClass);
        if (cachedName != null) {
            return cachedName;
        }
        String annName = MetaUtils.getBusinessNameFromAnnotation(businessClass);
        if (annName != null) {
            return annName;
        }
        String name = businessClass.getSimpleName();
        String[] strs = StringUtils.splitByCharacterTypeCamelCase((String)name);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            builder.append(strs[i].trim().toLowerCase());
            if (i >= strs.length - 1) continue;
            builder.append("_");
        }
        return builder.toString();
    }

    private static String getBusinessNameFromAnnotation(Class businessClass) {
        Business annotation = businessClass.getAnnotation(Business.class);
        if (annotation == null) {
            return null;
        }
        Business businessAnn = annotation;
        return businessAnn.value();
    }

    private static String getBusinessNameFromCache(Class businessClass) {
        DatahubMetaClass metaClass = DatahubBeanUtil.getMetaClassFromCache(businessClass);
        if (metaClass == null) {
            return null;
        }
        return metaClass.getName();
    }

    public static DatahubProperty getPropertyOfClass(Class cls, String propName) {
        DatahubMetaClass metaClass = DatahubBeanUtil.getMetaClass(cls);
        if (metaClass == null) {
            return null;
        }
        DatahubProperty property = metaClass.getProperty(propName);
        if (property == null && Map.class.isAssignableFrom(metaClass.getEntityClass())) {
            Type[] typeArray = cls.getGenericInterfaces();
        }
        return property;
    }
}

