/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.thebeastshop.datahub.client.DatahubClient;
import com.thebeastshop.datahub.client.annotation.AppId;
import com.thebeastshop.datahub.client.annotation.Creator;
import com.thebeastshop.datahub.client.annotation.DataCreateTime;
import com.thebeastshop.datahub.client.annotation.DataUpdateTime;
import com.thebeastshop.datahub.client.annotation.DbId;
import com.thebeastshop.datahub.client.annotation.Reviser;
import com.thebeastshop.datahub.client.criteria.Group;
import com.thebeastshop.datahub.client.criteria.Query;
import com.thebeastshop.datahub.client.exception.DatahubCreatorEmpty;
import com.thebeastshop.datahub.client.exception.DatahubIdEmpty;
import com.thebeastshop.datahub.client.exception.DatahubQueryException;
import com.thebeastshop.datahub.client.exception.DatahubQueryResultException;
import com.thebeastshop.datahub.client.exception.DatahubReviserEmpty;
import com.thebeastshop.datahub.client.exception.DatahubTimeoutException;
import com.thebeastshop.datahub.client.kafka.ResponseMessageListener;
import com.thebeastshop.datahub.client.utils.CriteriaUtils;
import com.thebeastshop.datahub.client.utils.DatahubBeanUtil;
import com.thebeastshop.datahub.client.utils.DatahubCallback;
import com.thebeastshop.datahub.client.utils.DatahubMetaClass;
import com.thebeastshop.datahub.client.utils.DatahubProperty;
import com.thebeastshop.datahub.client.utils.MessageUtil;
import com.thebeastshop.datahub.client.utils.MetaUtils;
import com.thebeastshop.datahub.common.api.AggregateResult;
import com.thebeastshop.datahub.common.api.QueryResult;
import com.thebeastshop.datahub.common.api.Result;
import com.thebeastshop.datahub.common.dto.AggregateNode;
import com.thebeastshop.datahub.common.dto.QueryNode;
import com.thebeastshop.datahub.common.enums.DataTypeEnum;
import com.thebeastshop.datahub.common.enums.MessageOperationEnum;
import com.thebeastshop.datahub.common.enums.MessageProtocolEnum;
import com.thebeastshop.datahub.common.enums.ResultCodeEnum;
import com.thebeastshop.datahub.common.vo.AggregationResult;
import com.thebeastshop.datahub.common.vo.BusinessMessage;
import com.thebeastshop.datahub.common.vo.BusinessProperty;
import com.thebeastshop.datahub.common.vo.BusinessRecord;
import com.thebeastshop.datahub.common.vo.BusinessStruct;
import com.thebeastshop.datahub.common.vo.ResponseMessage;
import com.thebeastshop.kit.prop.PropConstants;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class KafkaDatahubClient
implements DatahubClient {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_TIMEOUT = 30;
    private static int BATCH_SIZE = 100;
    private static int SLEEP_TIME_EACH_BATCH = 10;
    private static int HTTP_RETRY_COUNT = 5;
    private String appId;
    private String serialization;
    private KafkaTemplate kafkaTemplate;
    private ResponseMessageListener responseMessageListener;
    private String uri;
    private final PoolingHttpClientConnectionManager poolingConnManager = new PoolingHttpClientConnectionManager();
    private RequestConfig requestConfig;
    private long defaultResponseTimeout;

    public KafkaDatahubClient(Map<String, String> properties, KafkaTemplate KafkaTemplate2, ResponseMessageListener responseMessageListener) {
        this.kafkaTemplate = KafkaTemplate2;
        this.responseMessageListener = responseMessageListener;
        String string = this.appId = StringUtils.isNotBlank((CharSequence)properties.get("appId")) ? properties.get("appId") : PropConstants.getAppId();
        if (StringUtils.isBlank((CharSequence)this.appId)) {
            throw new NoSuchFieldError("appId is blank");
        }
        this.serialization = StringUtils.isNotBlank((CharSequence)properties.get("serialization")) ? properties.get("serialization") : "kryo";
        String responseTimeout = StringUtils.isNotBlank((CharSequence)properties.get("responseTimeout")) ? properties.get("responseTimeout") : "60000";
        this.defaultResponseTimeout = Long.parseLong(responseTimeout.trim());
        String address = properties.get("address");
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new NoSuchFieldError("address is blank");
        }
        this.uri = !address.startsWith("http") ? "http://" + address : address;
        this.uri = this.uri + "/datahub/" + this.appId;
        this.poolingConnManager.setMaxTotal(50);
        this.poolingConnManager.setDefaultMaxPerRoute(50);
        int timeout = 30;
        if (StringUtils.isNotBlank((CharSequence)properties.get("timeout"))) {
            timeout = Integer.valueOf(properties.get("timeout"));
        }
        this.requestConfig = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.DisableCircularReferenceDetect.getMask();
    }

    private HttpClient buildHttpClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.poolingConnManager).setDefaultRequestConfig(this.requestConfig).build();
    }

    private <T> BusinessStruct convertT2Struct(T t) {
        String bizName = MetaUtils.getBusinessName(t.getClass());
        BusinessStruct struct = new BusinessStruct(bizName);
        DatahubMetaClass metaClass = DatahubBeanUtil.getMetaClass(t.getClass());
        Map<String, DatahubProperty> allProperties = metaClass.getAllProperties();
        ArrayList properties = Lists.newArrayListWithCapacity((int)allProperties.size());
        for (DatahubProperty prop : allProperties.values()) {
            if (prop.isCommon()) continue;
            String propName = prop.getName();
            try {
                DataTypeEnum dataType = prop.getDataType();
                if (dataType == null) continue;
                Object value = prop.getValue(t);
                value = dataType.castValue(value, null);
                properties.add(new BusinessProperty(dataType, propName, value));
            }
            catch (IllegalAccessException e) {
                this.log.error("\u6cdb\u578b\u5b9e\u4f8b\u8f6c\u6362\u4e1a\u52a1\u7ed3\u6784\u51fa\u9519: \u5b57\u6bb5: {}", (Object)propName, (Object)e);
            }
            catch (InvocationTargetException e) {
                this.log.error("\u6cdb\u578b\u5b9e\u4f8b\u8f6c\u6362\u4e1a\u52a1\u7ed3\u6784\u51fa\u9519: \u5b57\u6bb5: {}", (Object)propName, (Object)e);
            }
        }
        struct.setProperties((List)properties);
        return struct;
    }

    private <T> T convertStruct2T(BusinessRecord businessRecord, Class<T> tClass) {
        T bean = null;
        try {
            bean = tClass.newInstance();
            HashMap<Class, Object> commonMap = new HashMap<Class, Object>();
            commonMap.put(DbId.class, businessRecord.getId());
            commonMap.put(AppId.class, businessRecord.getAppId());
            commonMap.put(Creator.class, businessRecord.getCreator());
            commonMap.put(Reviser.class, businessRecord.getReviser());
            commonMap.put(DataCreateTime.class, businessRecord.getCreateTime());
            commonMap.put(DataUpdateTime.class, businessRecord.getUpdateTime());
            HashMap<String, Object> bizMap = new HashMap<String, Object>();
            BusinessStruct struct = businessRecord.getBusiness();
            for (BusinessProperty property : struct.getProperties()) {
                Object val = property.getValue();
                if (val == null) continue;
                bizMap.put(property.getName(), val);
            }
            DatahubMetaClass metaClass = DatahubBeanUtil.getMetaClass(tClass);
            Map<String, DatahubProperty> properties = metaClass.getAllProperties();
            for (Map.Entry<String, DatahubProperty> entry : properties.entrySet()) {
                String key = entry.getKey();
                DatahubProperty property = entry.getValue();
                Object value = property.isCommon() ? commonMap.get(property.getAnnotationType()) : bizMap.get(key);
                if (value == null) continue;
                try {
                    DataTypeEnum dataType = property.getDataType();
                    Type genericType = property.getGenericPropertyType();
                    value = dataType.castValue(value, genericType);
                    property.setValue(bean, value);
                }
                catch (Throwable th) {
                    this.log.error("\u8bbe\u7f6e\u6cdb\u578b\u5b9e\u4f8b\u5c5e\u6027\u503c\u51fa\u9519: fieldName: {}", (Object)property.getName(), (Object)th);
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u4e1a\u52a1\u7ed3\u6784\u8f6c\u6362\u6cdb\u578b\u5b9e\u4f8b\u51fa\u9519:", (Throwable)e);
        }
        return bean;
    }

    private <T> void batchProcess(List<T> records, BatchCallback callback) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        int batch = records.size() / BATCH_SIZE;
        if (records.size() % BATCH_SIZE > 0) {
            ++batch;
        }
        this.log.info("[DATAHUB] batch start =>> batch size: " + batch);
        int offset = 0;
        for (int i = 0; i < batch; ++i) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)BATCH_SIZE);
            int batchSize = BATCH_SIZE;
            if (i == batch - 1) {
                batchSize = records.size() - BATCH_SIZE * (batch - 1);
            }
            for (int j = 0; j < batchSize; ++j) {
                T record = records.get(offset++);
                list.add(record);
            }
            callback.call(list);
            if (i >= batch - 1) continue;
            try {
                Thread.sleep(SLEEP_TIME_EACH_BATCH);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private ResponseMessage awaitMessage(boolean timed, BlockingQueue<ResponseMessage> blockingQueue, long timeout) {
        ResponseMessage message = null;
        try {
            message = timed ? blockingQueue.poll(timeout, TimeUnit.MILLISECONDS) : blockingQueue.poll(this.defaultResponseTimeout, TimeUnit.MILLISECONDS);
            if (message == null) {
                throw new DatahubTimeoutException();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return message;
    }

    @Override
    public List<String> getBusinessNameList() {
        try {
            String rt = this.httpGet("biznames");
            if (StringUtils.isNotBlank((CharSequence)rt)) {
                List result = JSON.parseArray((String)rt, String.class);
                return result;
            }
            throw new DatahubQueryException(new Exception("\u83b7\u53d6\u4e1a\u52a1\u5b9e\u4f53\u540d\u79f0\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef"));
        }
        catch (IOException e) {
            if (e instanceof SocketTimeoutException) {
                this.log.error("[DATAHUB] \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6", (Throwable)e);
                throw new RuntimeException("[DATAHUB] \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6");
            }
            this.log.error("[DATAHUB] \u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u51fa\u9519\uff1a", (Throwable)e);
            throw new DatahubQueryException(e);
        }
    }

    @Override
    public <T> String create(T record) {
        return this.batchCreate(Lists.newArrayList((Object[])new Object[]{record}));
    }

    @Override
    public <T> String create(T record, DatahubCallback callback) {
        return this.batchCreate(Lists.newArrayList((Object[])new Object[]{record}), callback);
    }

    @Override
    public <T> String create(T record, DatahubCallback callback, ListenableFutureCallback<SendResult> listenableFutureCallback) {
        return this.batchCreate(Lists.newArrayList((Object[])new Object[]{record}), callback, listenableFutureCallback);
    }

    private <T> ResponseMessage createAndWait(boolean timed, T record, long timeout) {
        String messageId = MessageUtil.getMessageId();
        LinkedBlockingQueue<ResponseMessage> blockingQueue = new LinkedBlockingQueue<ResponseMessage>();
        this.batchCreate(messageId, Lists.newArrayList((Object[])new Object[]{record}), response -> blockingQueue.add(response), null);
        return this.awaitMessage(timed, blockingQueue, timeout);
    }

    @Override
    public <T> ResponseMessage createAndWait(T record) {
        return this.createAndWait(false, record, this.defaultResponseTimeout);
    }

    @Override
    public <T> ResponseMessage createAndWait(T record, long timeout) {
        return this.createAndWait(true, record, timeout);
    }

    private <T> void batchCreate(String messageId, List<T> records, DatahubCallback callback, ListenableFutureCallback<SendResult> listenableFutureCallback) {
        this.batchProcess(records, list -> {
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            ArrayList brList = Lists.newArrayListWithExpectedSize((int)list.size());
            for (Object record : list) {
                String creator = DatahubBeanUtil.getCreator(record);
                if (StringUtils.isBlank((CharSequence)creator)) {
                    throw new DatahubCreatorEmpty(record.getClass());
                }
                Date createTime = DatahubBeanUtil.getCreateTime(record);
                Date updateTime = DatahubBeanUtil.getUpdateTime(record);
                BusinessRecord br = new BusinessRecord();
                br.setAppId(this.appId);
                br.setCreator(creator);
                br.setCreateTime(createTime);
                br.setUpdateTime(updateTime);
                br.setBusiness(this.convertT2Struct(record));
                brList.add(br);
            }
            ListenableFuture future = this.kafkaTemplate.send("datahub", (Object)new BusinessMessage(messageId, this.responseMessageListener.getResponseTopicName(), MessageOperationEnum.CREATE, MessageProtocolEnum.valueOf((String)this.serialization.toUpperCase()), (List)brList));
            if (listenableFutureCallback != null) {
                future.addCallback(listenableFutureCallback);
            }
            this.responseMessageListener.putCallback(messageId, callback);
        });
    }

    @Override
    public <T> String batchCreate(List<T> records) {
        return this.batchCreate(records, null);
    }

    @Override
    public <T> String batchCreate(List<T> records, DatahubCallback callback) {
        return this.batchCreate(records, callback, null);
    }

    @Override
    public <T> String batchCreate(List<T> records, DatahubCallback callback, ListenableFutureCallback<SendResult> listenableFutureCallback) {
        String messageId = MessageUtil.getMessageId();
        this.batchCreate(messageId, records, callback, listenableFutureCallback);
        return messageId;
    }

    private <T> ResponseMessage batchCreateAndWait(boolean timed, List<T> records, long timeout) {
        String messageId = MessageUtil.getMessageId();
        LinkedBlockingQueue<ResponseMessage> blockingQueue = new LinkedBlockingQueue<ResponseMessage>();
        this.batchCreate(messageId, records, response -> blockingQueue.add(response), null);
        return this.awaitMessage(timed, blockingQueue, timeout);
    }

    @Override
    public <T> ResponseMessage batchCreateAndWait(List<T> records) {
        return this.batchCreateAndWait(false, records, this.defaultResponseTimeout);
    }

    @Override
    public <T> ResponseMessage batchCreateAndWait(List<T> records, long timeout) {
        return this.batchCreateAndWait(true, records, timeout);
    }

    @Override
    public <T> void update(T record) {
        this.batchUpdate(Lists.newArrayList((Object[])new Object[]{record}));
    }

    private <T> void batchUpdate(final String messageId, List<T> records, final DatahubCallback callback) {
        this.batchProcess(records, new BatchCallback<T>(){

            @Override
            public void call(List<T> list) {
                if (CollectionUtils.isEmpty(list)) {
                    return;
                }
                ArrayList brList = Lists.newArrayListWithExpectedSize((int)list.size());
                for (Object record : list) {
                    String id = DatahubBeanUtil.getId(record);
                    if (id == null) {
                        throw new DatahubIdEmpty(record.getClass(), id);
                    }
                    String reviser = DatahubBeanUtil.getReviser(record);
                    if (reviser == null) {
                        throw new DatahubReviserEmpty(record.getClass(), id);
                    }
                    BusinessRecord br = new BusinessRecord();
                    br.setId(id);
                    br.setReviser(reviser);
                    br.setAppId(KafkaDatahubClient.this.appId);
                    br.setBusiness(KafkaDatahubClient.this.convertT2Struct(record));
                    brList.add(br);
                }
                KafkaDatahubClient.this.kafkaTemplate.send("datahub", (Object)new BusinessMessage(messageId, KafkaDatahubClient.this.responseMessageListener.getResponseTopicName(), MessageOperationEnum.UPDATE, MessageProtocolEnum.valueOf((String)KafkaDatahubClient.this.serialization.toUpperCase()), (List)brList));
                KafkaDatahubClient.this.responseMessageListener.putCallback(messageId, callback);
            }
        });
    }

    @Override
    public <T> String batchUpdate(List<T> records) {
        String messageId = MessageUtil.getMessageId();
        this.batchUpdate(messageId, records, null);
        return messageId;
    }

    @Override
    public <T> String batchUpdate(List<T> records, DatahubCallback callback) {
        String messageId = MessageUtil.getMessageId();
        this.batchUpdate(messageId, records, callback);
        return messageId;
    }

    private <T> ResponseMessage batchUpdateAndWait(boolean timed, List<T> records, long timeout) {
        String messageId = MessageUtil.getMessageId();
        LinkedBlockingQueue<ResponseMessage> blockingQueue = new LinkedBlockingQueue<ResponseMessage>();
        this.batchUpdate(messageId, records, response -> blockingQueue.add(response));
        return this.awaitMessage(timed, blockingQueue, timeout);
    }

    @Override
    public <T> ResponseMessage batchUpdateAndWait(List<T> records) {
        return this.batchUpdateAndWait(false, records, this.defaultResponseTimeout);
    }

    @Override
    public <T> ResponseMessage batchUpdateAndWait(List<T> records, long timeout) {
        return this.batchUpdateAndWait(true, records, timeout);
    }

    @Override
    public <T> T getByDbId(Class<T> tClass, String dbId) {
        return this.getByDbId(tClass, dbId, 0);
    }

    public <T> T getByDbId(Class<T> tClass, String dbId, int retryCount) {
        try {
            String bizName = DatahubBeanUtil.getMetaClass(tClass).getName();
            HttpClient httpClient = this.buildHttpClient();
            HttpGet httpGet = new HttpGet(this.uri + "/" + bizName + "/" + dbId);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String rt = EntityUtils.toString((HttpEntity)entity);
            if (StringUtils.isNotBlank((CharSequence)rt)) {
                Result result = (Result)JSON.parseObject((String)rt, (TypeReference)new TypeReference<Result<BusinessRecord>>(){}, (Feature[])new Feature[0]);
                if (result.getCode().equals(ResultCodeEnum.OK.code)) {
                    T t = null;
                    if (result.getData() != null) {
                        t = this.convertStruct2T((BusinessRecord)result.getData(), tClass);
                    }
                    return t;
                }
                this.log.error("[DATAHUB] \u6839\u636edbId\u67e5\u8be2\u8bb0\u5f55api\u51fa\u9519: code: {}, message: {}", (Object)result.getCode(), (Object)result.getMessage());
                throw new DatahubQueryResultException(result);
            }
        }
        catch (Exception e) {
            if (e instanceof DatahubQueryResultException) {
                throw (DatahubQueryResultException)e;
            }
            if (e instanceof SocketTimeoutException) {
                this.log.error("[DATAHUB] \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6", (Throwable)e);
                throw new RuntimeException("[DATAHUB] \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6");
            }
            if (e instanceof NoHttpResponseException) {
                if (retryCount < HTTP_RETRY_COUNT) {
                    this.log.warn("[DATAHUB] \u67e5\u8be2\u65f6\u51fa\u73b0\u7f51\u7edc\u9519\u8bef\uff0c\u8fdb\u884c\u91cd\u65b0\u67e5\u8be2\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + retryCount);
                    return this.getByDbId(tClass, dbId, ++retryCount);
                }
                throw new RuntimeException("[DATAHUB] \u67e5\u8be2\u65f6\u7f51\u7edc\u51fa\u73b0\u9519\u8bef, \u91cd\u8bd5\u6b21\u6570\uff1a" + retryCount + ", \u539f\u56e0\uff1a" + e);
            }
            this.log.error("[DATAHUB] \u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u51fa\u9519\uff1a", (Throwable)e);
            throw new DatahubQueryException(e);
        }
        return null;
    }

    @Override
    public List<AggregateResult> aggregate(Query query, Group ... group) {
        return this.aggregate(query, group, 0);
    }

    public List<AggregateResult> aggregate(Query query, Group[] groups, int retryCount) {
        if (query == null) {
            throw new RuntimeException("[DATAHUB] \u53c2\u6570 query \u4e3a null");
        }
        if (groups == null) {
            throw new RuntimeException("[DATAHUB] \u53c2\u6570 groups \u4e3a null");
        }
        try {
            Validate.notNull(query.getEntityClass());
            String path = MetaUtils.getBusinessName(query.getEntityClass()) + "/aggregate";
            AggregateNode aggregateNode = CriteriaUtils.toAggregateNode(query, groups);
            Validate.notNull((Object)aggregateNode);
            String json = JSON.toJSONString((Object)aggregateNode);
            Validate.notNull((Object)json);
            String rt = this.httpPost(path, json);
            if (StringUtils.isNotBlank((CharSequence)rt)) {
                Result jsonResult = (Result)JSON.parseObject((String)rt, (TypeReference)new TypeReference<Result<List<AggregationResult>>>(){}, (Feature[])new Feature[0]);
                if (jsonResult.getCode().equals(ResultCodeEnum.OK.code)) {
                    ArrayList tList;
                    List aggregateResults = (List)jsonResult.getData();
                    if (aggregateResults != null) {
                        tList = Lists.newArrayListWithCapacity((int)aggregateResults.size());
                        for (AggregationResult aggregationResult : aggregateResults) {
                            AggregateResult aggregateResult = new AggregateResult();
                            BeanUtils.copyProperties((Object)aggregationResult, (Object)aggregateResult);
                            tList.add(aggregateResult);
                        }
                    } else {
                        tList = Lists.newArrayList();
                    }
                    return tList;
                }
                this.log.error("[DATAHUB] \u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55api\u51fa\u9519: code: {}, message: {}", (Object)jsonResult.getCode(), (Object)jsonResult.getMessage());
                throw new DatahubQueryResultException(jsonResult);
            }
        }
        catch (Throwable e) {
            if (e instanceof DatahubQueryResultException) {
                throw (DatahubQueryResultException)e;
            }
            if (e instanceof SocketTimeoutException) {
                this.log.error("[DATAHUB] \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6", e);
                throw new RuntimeException("[DATAHUB] \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6");
            }
            if (e instanceof NoHttpResponseException) {
                if (retryCount < HTTP_RETRY_COUNT) {
                    this.log.warn("[DATAHUB] \u67e5\u8be2\u65f6\u51fa\u73b0\u7f51\u7edc\u9519\u8bef\uff0c\u8fdb\u884c\u91cd\u65b0\u67e5\u8be2\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + ++retryCount);
                    return this.aggregate(query, groups, retryCount);
                }
                throw new RuntimeException("[DATAHUB] \u67e5\u8be2\u65f6\u7f51\u7edc\u51fa\u73b0\u9519\u8bef\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + retryCount + "\uff0c\u9519\u8bef\uff1a" + e);
            }
            this.log.error("[DATAHUB] \u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u51fa\u9519\uff1a", e);
            throw new DatahubQueryException(e);
        }
        return null;
    }

    @Override
    public <T> QueryResult<T> find(Query query) {
        return this.find(query, 0);
    }

    public <T> QueryResult<T> find(Query query, int retryCount) {
        block16: {
            if (query == null) {
                throw new RuntimeException("[DATAHUB] \u53c2\u6570 query \u4e3a null");
            }
            try {
                String path = MetaUtils.getBusinessName(query.getEntityClass()) + "/search";
                QueryNode queryNode = CriteriaUtils.toQueryNode(query);
                String json = JSON.toJSONString((Object)queryNode);
                Validate.notNull((Object)json);
                if (retryCount == 0) {
                    this.log.info("[DATAHUB] find Query: " + json);
                } else {
                    this.log.info("[DATAHUB] [Retry Count: {}] find Query: {}", (Object)retryCount, (Object)json);
                }
                String rt = this.httpPost(path, json);
                if (!StringUtils.isNotBlank((CharSequence)rt)) break block16;
                Result jsonResult = null;
                try {
                    jsonResult = (Result)JSON.parseObject((String)rt, (TypeReference)new TypeReference<Result<QueryResult<BusinessRecord>>>(){}, (Feature[])new Feature[0]);
                }
                catch (Throwable th) {
                    this.log.error("[DATAHUB] [\u67e5\u8be2\u6761\u4ef6: " + json + "] [\u67e5\u8be2\u7ed3\u679c: " + rt + "] \u67e5\u8be2\u7ed3\u679c\u89e3\u6790\u51fa\u9519\uff1a", th);
                    throw new DatahubQueryException(query, th);
                }
                if (jsonResult == null) {
                    this.log.error("[DATAHUB] [\u67e5\u8be2\u6761\u4ef6: " + json + "] [\u67e5\u8be2\u7ed3\u679c: " + rt + "] \u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
                    throw new RuntimeException("[DATAHUB] [\u67e5\u8be2\u6761\u4ef6: " + json + "] [\u67e5\u8be2\u7ed3\u679c: " + rt + "] \u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
                }
                if (jsonResult.getCode().equals(ResultCodeEnum.OK.code)) {
                    ArrayList tList = null;
                    QueryResult result = new QueryResult();
                    QueryResult queryResult = (QueryResult)jsonResult.getData();
                    if (queryResult == null) {
                        this.log.error("[DATAHUB] [\u67e5\u8be2\u6761\u4ef6: " + json + "] [\u67e5\u8be2\u7ed3\u679c: " + rt + "] \u67e5\u8be2\u7ed3\u679c\u7684Data\u5b57\u6bb5\u4e3a\u7a7a");
                        throw new RuntimeException("[DATAHUB] [\u67e5\u8be2\u6761\u4ef6: " + json + "] [\u67e5\u8be2\u7ed3\u679c: " + rt + "] \u67e5\u8be2\u7ed3\u679c\u7684Data\u5b57\u6bb5\u4e3a\u7a7a");
                    }
                    List businessRecords = queryResult.getData();
                    if (businessRecords != null) {
                        tList = Lists.newArrayListWithCapacity((int)businessRecords.size());
                        for (BusinessRecord businessRecord : businessRecords) {
                            Class tClass = query.getEntityClass();
                            Object t = this.convertStruct2T(businessRecord, tClass);
                            tList.add(t);
                        }
                    }
                    result.setData(tList);
                    result.setPage(queryResult.getPage());
                    result.setPageSize(queryResult.getPageSize());
                    result.setNextId(queryResult.getNextId());
                    result.setHasNextPage(queryResult.getHasNextPage());
                    result.setTotalCount(queryResult.getTotalCount());
                    return result;
                }
                this.log.error("[DATAHUB] \u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55api\u51fa\u9519: code: {}, message: {}", (Object)jsonResult.getCode(), (Object)jsonResult.getMessage());
                throw new DatahubQueryResultException(jsonResult);
            }
            catch (Throwable e) {
                if (e instanceof DatahubQueryResultException) {
                    throw (DatahubQueryResultException)e;
                }
                if (e instanceof SocketTimeoutException) {
                    this.log.error("[DATAHUB] \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6", e);
                    throw new RuntimeException("[DATAHUB] \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6");
                }
                if (e instanceof NoHttpResponseException) {
                    if (retryCount < HTTP_RETRY_COUNT) {
                        this.log.warn("[DATAHUB] \u67e5\u8be2\u65f6\u51fa\u73b0\u7f51\u7edc\u9519\u8bef\uff0c\u8fdb\u884c\u91cd\u65b0\u67e5\u8be2\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + ++retryCount);
                        return this.find(query, retryCount);
                    }
                    throw new RuntimeException("[DATAHUB] \u67e5\u8be2\u65f6\u7f51\u7edc\u51fa\u73b0\u9519\u8bef\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + retryCount + "\uff0c\u9519\u8bef\uff1a" + e);
                }
                this.log.error("[DATAHUB] \u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u51fa\u9519\uff1a", e);
                throw new DatahubQueryException(query, e);
            }
        }
        return null;
    }

    @Override
    public QueryResult<BusinessRecord> findAsRecords(Query query, String businessName) {
        return this.findAsRecord(query, businessName, 0);
    }

    public QueryResult<BusinessRecord> findAsRecord(Query query, String businessName, int retryCount) {
        try {
            String path = businessName + "/search";
            QueryNode queryNode = CriteriaUtils.toQueryNode(query);
            String json = JSON.toJSONString((Object)queryNode);
            if (retryCount == 0) {
                this.log.info("[DATAHUB] find as record, Query: " + json);
            } else {
                this.log.info("[DATAHUB] [Retry Count: {}] find as record, Query: {}", (Object)retryCount, (Object)json);
            }
            String rt = this.httpPost(path, json);
            if (StringUtils.isNotBlank((CharSequence)rt)) {
                Result result = (Result)JSON.parseObject((String)rt, (TypeReference)new TypeReference<Result<QueryResult<BusinessRecord>>>(){}, (Feature[])new Feature[0]);
                return (QueryResult)result.getData();
            }
        }
        catch (Throwable e) {
            if (e instanceof DatahubQueryResultException) {
                throw (DatahubQueryResultException)e;
            }
            if (e instanceof SocketTimeoutException) {
                this.log.error("[DATAHUB] \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6", e);
                throw new RuntimeException("[DATAHUB] \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6");
            }
            if (e instanceof NoHttpResponseException) {
                if (retryCount < HTTP_RETRY_COUNT) {
                    this.log.warn("[DATAHUB] \u67e5\u8be2\u65f6\u51fa\u73b0\u7f51\u7edc\u9519\u8bef\uff0c\u8fdb\u884c\u91cd\u65b0\u67e5\u8be2\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + ++retryCount);
                    return this.findAsRecord(query, businessName, retryCount);
                }
                throw new RuntimeException("[DATAHUB] \u67e5\u8be2\u65f6\u7f51\u7edc\u51fa\u73b0\u9519\u8bef\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + retryCount + "\uff0c\u9519\u8bef\uff1a" + e);
            }
            this.log.error("[DATAHUB] [\u67e5\u8be2\u6761\u4ef6: " + JSONObject.toJSONString((Object)query) + "] \u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u51fa\u9519\uff1a", e);
            throw new DatahubQueryException(query, e);
        }
        return null;
    }

    private String httpPost(String path, String postBody) throws IOException {
        HttpClient httpClient = this.buildHttpClient();
        HttpPost httpPost = new HttpPost(this.uri + "/" + path);
        httpPost.setEntity((HttpEntity)new StringEntity(postBody, ContentType.APPLICATION_JSON));
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        String rt = EntityUtils.toString((HttpEntity)entity);
        return rt;
    }

    private String httpGet(String path) throws IOException {
        HttpClient httpClient = this.buildHttpClient();
        HttpGet httpGet = new HttpGet(this.uri + "/" + path);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        HttpEntity entity = response.getEntity();
        String rt = EntityUtils.toString((HttpEntity)entity);
        return rt;
    }

    static interface BatchCallback<T> {
        public void call(List<T> var1);
    }
}

