/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.utils;

import com.thebeastshop.bgel.runtime.BgelRange;
import com.thebeastshop.bgel.utils.MetaHelper;
import com.thebeastshop.datahub.client.exception.DatahubCastException;
import com.thebeastshop.datahub.client.exception.DatahubGrammerException;
import com.thebeastshop.datahub.client.utils.DatahubBeanUtil;
import com.thebeastshop.datahub.client.utils.DatahubMetaClass;
import com.thebeastshop.datahub.client.utils.DatahubProperty;
import com.thebeastshop.datahub.client.utils.MetaUtils;
import com.thebeastshop.datahub.common.dto.CriteriaNode;
import com.thebeastshop.datahub.common.enums.CriteriaOperatorEnum;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class TypeCaster {
    private static Object castValue(CriteriaNode criteriaNode, Class<?> entityClass, Class targetType, Object value) {
        try {
            value = MetaHelper.cast((Class)targetType, (Object)value);
            return value;
        }
        catch (Throwable th) {
            throw new RuntimeException("[DATAHUB] " + MetaUtils.getBusinessName(value.getClass()) + "(" + TypeCaster.valueString(value) + ") \u4e0d\u80fd\u8f6c\u5316\u4e3a\u5b57\u6bb5 " + MetaUtils.getBusinessName(entityClass) + "." + criteriaNode.getKey() + "\u7684\u7c7b\u578b[" + targetType + "]", th);
        }
    }

    public static void cast(CriteriaNode criteriaNode, Class<?> entityClass) {
        String key = criteriaNode.getKey();
        Object value = criteriaNode.getValue();
        DatahubMetaClass metaClass = DatahubBeanUtil.getMetaClass(entityClass);
        if (key != null && value != null) {
            DatahubProperty property = metaClass.getProperty(key);
            if (property == null) {
                if (TypeCaster.isCommonField(key)) {
                    throw new DatahubCastException("\u516c\u5171\u5b57\u6bb5'" + MetaUtils.getBusinessName(entityClass) + "." + key + "'\u4e0d\u5b58\u5728!");
                }
                throw new DatahubCastException("\u5b9e\u4f53\u7c7b'" + entityClass.getSimpleName() + "'\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5'" + key + "'!");
            }
            if (property.isCommon()) {
                if (!property.isCanUse()) {
                    throw new DatahubCastException("\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u8be2\u516c\u5171\u5b57\u6bb5'" + MetaUtils.getBusinessName(entityClass) + "." + key + "'!");
                }
                criteriaNode.setKey(property.getCommonName());
            }
            if (!property.hasSetter()) {
                throw new DatahubCastException("\u5b9e\u4f53\u7c7b'" + entityClass.getSimpleName() + "'\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5'" + key + "'!");
            }
            Class targetType = property.getPropertyType();
            if (criteriaNode.getOp() == CriteriaOperatorEnum.IN) {
                if (value == null || !(value instanceof Iterable)) {
                    throw new DatahubGrammerException("\u5bf9\u4e8e\u8868\u8fbe\u5f0f '" + String.valueOf(value) + "' \u4e0d\u80fd\u7528\u64cd\u4f5c\u7b26 'in'!");
                }
                if (value instanceof BgelRange) {
                    BgelRange range = (BgelRange)value;
                    Comparable from = range.getFrom();
                    Comparable to = range.getTo();
                    Comparable fromValue = (Comparable)TypeCaster.castValue(criteriaNode, entityClass, targetType, from);
                    Comparable toValue = (Comparable)TypeCaster.castValue(criteriaNode, entityClass, targetType, to);
                    BgelRange newRange = new BgelRange(fromValue, toValue, range.getStep(), range.isIncludeFrom(), range.isIncludeTo());
                    criteriaNode.setValue((Object)newRange);
                } else {
                    ArrayList list = new ArrayList();
                    for (Object itemValue : (Iterable)value) {
                        itemValue = TypeCaster.castValue(criteriaNode, entityClass, targetType, itemValue);
                        list.add(itemValue);
                    }
                    criteriaNode.setValue(list);
                }
            } else {
                if (criteriaNode.getOp() == CriteriaOperatorEnum.REGEX_MATCH && (value instanceof Pattern || value instanceof CharSequence)) {
                    return;
                }
                value = TypeCaster.castValue(criteriaNode, entityClass, targetType, value);
                criteriaNode.setValue(value);
            }
        }
        if (criteriaNode.getChildren() != null) {
            for (CriteriaNode child : criteriaNode.getChildren()) {
                TypeCaster.cast(child, entityClass);
            }
        }
    }

    private static boolean isCommonField(String fieldName) {
        return fieldName.startsWith("$");
    }

    private static String valueString(Object value) {
        if (value instanceof CharSequence) {
            return "\"" + value + "\"";
        }
        return value.toString();
    }
}

