/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.criteria;

import com.thebeastshop.datahub.client.criteria.GroupItem;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Group {
    private final String[] groupByKeys;
    private Map<String, GroupItem> items = new LinkedHashMap<String, GroupItem>();
    private String lastKey;
    private int index = 0;

    private Group(String ... groupByKeys) {
        this.groupByKeys = groupByKeys;
    }

    public static Group by(String ... keys) {
        Group group = new Group(keys);
        return group;
    }

    public static Group byNothing() {
        return Group.by(null);
    }

    public String[] getGroupByKeys() {
        return this.groupByKeys;
    }

    public Group count() {
        this.lastKey = this.addGroupItem(null, "$count", null);
        return this;
    }

    public Group sum(Object arg) {
        this.lastKey = this.addGroupItem(null, "$sum", arg);
        return this;
    }

    public Group avg(Object arg) {
        this.lastKey = this.addGroupItem(null, "$avg", arg);
        return this;
    }

    public Group max(Object arg) {
        this.lastKey = this.addGroupItem(null, "$max", arg);
        return this;
    }

    public Group min(Object arg) {
        this.lastKey = this.addGroupItem(null, "$min", arg);
        return this;
    }

    public Group first(Object arg) {
        this.lastKey = this.addGroupItem(null, "$first", arg);
        return this;
    }

    public Group last(Object arg) {
        this.lastKey = this.addGroupItem(null, "$last", arg);
        return this;
    }

    public Group as(String alias) {
        if (StringUtils.isBlank((CharSequence)this.lastKey)) {
            throw new RuntimeException(" [DATAHUB] \u8c03\u7528as\u65b9\u6cd5\u524d\u5148\u8c03\u7528\u805a\u5408\u65b9\u6cd5\uff0c\u5982: sum\u3001min\u3001max\u7b49");
        }
        GroupItem item = this.items.get(this.lastKey);
        if (item == null) {
            return this;
        }
        item.setAlias(alias);
        this.items.remove(this.lastKey);
        this.items.put(alias, item);
        this.lastKey = null;
        return this;
    }

    public Map<String, GroupItem> getGroupItems() {
        return this.items;
    }

    private String addGroupItem(String alias, String function, Object arg) {
        if (alias == null) {
            alias = this.getKeyAndIncIndexByIndex();
        }
        GroupItem item = new GroupItem(function, arg, alias);
        this.items.put(alias, item);
        return alias;
    }

    private String getKeyAndIncIndexByIndex() {
        return "$index_" + this.index++;
    }
}

