/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.criteria;

import com.thebeastshop.datahub.common.enums.CriteriaOperatorEnum;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class Criteria {
    private String key;
    private CriteriaOperatorEnum op;
    private List<Criteria> criteriaChain;
    private Object value;
    private Criteria head;
    private Criteria right;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public CriteriaOperatorEnum getOp() {
        return this.op;
    }

    public void setOp(CriteriaOperatorEnum op) {
        this.op = op;
    }

    public List<Criteria> getCriteriaChain() {
        return this.criteriaChain;
    }

    public void setCriteriaChain(List<Criteria> criteriaChain) {
        this.criteriaChain = criteriaChain;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Criteria getRight() {
        return this.right;
    }

    public void setRight(Criteria right) {
        this.right = right;
    }

    public Criteria getHead() {
        return this.head;
    }

    public void setHead(Criteria head) {
        this.head = head;
    }

    public Criteria() {
        this.criteriaChain = new LinkedList<Criteria>();
        this.head = this;
    }

    public Criteria(String key) {
        this.key = key;
        this.criteriaChain = new LinkedList<Criteria>();
        this.head = this;
    }

    public Criteria(Criteria head, Criteria prev, String key) {
        this.key = key;
        this.criteriaChain = new LinkedList<Criteria>();
        this.head = head;
        prev.setRight(this);
    }

    public static Criteria key(String key) {
        return new Criteria(key);
    }

    public static Criteria or(Criteria ... criteria) {
        List<Criteria> criteriaList = Arrays.asList(criteria);
        Criteria orCriteria = new Criteria("$or");
        orCriteria.setOp(CriteriaOperatorEnum.OR);
        criteriaList.stream().forEach(item -> orCriteria.criteriaChain.add(item.getHead()));
        return orCriteria;
    }

    private Criteria operateValue(CriteriaOperatorEnum op, Object value) {
        this.op = op;
        this.value = value;
        return this;
    }

    public Criteria eq(Object value) {
        return this.operateValue(CriteriaOperatorEnum.EQ, value);
    }

    public Criteria ne(Object value) {
        return this.operateValue(CriteriaOperatorEnum.NE, value);
    }

    public Criteria lt(Object value) {
        return this.operateValue(CriteriaOperatorEnum.LT, value);
    }

    public Criteria gt(Object value) {
        return this.operateValue(CriteriaOperatorEnum.GT, value);
    }

    public Criteria le(Object value) {
        return this.operateValue(CriteriaOperatorEnum.LE, value);
    }

    public Criteria ge(Object value) {
        return this.operateValue(CriteriaOperatorEnum.GE, value);
    }

    public Criteria regexMatch(String value) {
        return this.operateValue(CriteriaOperatorEnum.REGEX_MATCH, value);
    }

    public Criteria regexMatch(Pattern value) {
        return this.operateValue(CriteriaOperatorEnum.REGEX_MATCH, value);
    }

    public Criteria notRegexMatch(String value) {
        return this.operateValue(CriteriaOperatorEnum.NOT_REGEX_MATCH, value);
    }

    public Criteria notRegexMatch(Pattern value) {
        return this.operateValue(CriteriaOperatorEnum.NOT_REGEX_MATCH, value);
    }

    public Criteria in(List<Object> value) {
        return this.operateValue(CriteriaOperatorEnum.IN, value);
    }

    public Criteria in(Object ... value) {
        return this.operateValue(CriteriaOperatorEnum.IN, Arrays.asList(value));
    }

    public Criteria and(String key) {
        return new Criteria(this.head, this, key);
    }

    public Criteria orOperate(Criteria ... criteria) {
        List<Criteria> criteriaList = Arrays.asList(criteria);
        Criteria orCriteria = new Criteria(this.head, this, "$or");
        orCriteria.setOp(CriteriaOperatorEnum.OR);
        criteriaList.stream().forEach(item -> orCriteria.criteriaChain.add(item.getHead()));
        return orCriteria;
    }
}

