/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.redis;

import com.thebeastshop.common.redis.RedisNamedScript;
import com.thebeastshop.common.redis.RedisScriptParser;
import com.thebeastshop.common.redis.RedisScriptSource;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisScriptManager {
    private static final Logger log = LoggerFactory.getLogger(RedisScriptManager.class);
    private static final RedisScriptManager instance = new RedisScriptManager();
    private Map<String, RedisNamedScript> namedScriptMap = new HashMap<String, RedisNamedScript>();
    private Map<String, RedisScriptSource> scriptSourceMap = new HashMap<String, RedisScriptSource>();

    public static RedisScriptManager scriptManager() {
        return instance;
    }

    public RedisNamedScript getNamedScript(String name) {
        return this.namedScriptMap.get(name);
    }

    public void addNamedScript(RedisNamedScript namedScript) {
        this.namedScriptMap.put(namedScript.getName(), namedScript);
    }

    public RedisScriptSource loadScriptSource(URL url) throws IOException {
        log.info(" [Redis] \u52a0\u8f7dLua\u6e90\u6587\u4ef6\uff1a" + url.getPath());
        String path = url.getPath();
        RedisScriptSource source = this.scriptSourceMap.get(path);
        if (source == null) {
            source = new RedisScriptSource(url);
            this.scriptSourceMap.put(path, source);
            source.read();
        }
        return source;
    }

    public RedisScriptSource loadScriptSource(String path) throws IOException {
        return this.loadScriptSource(new URL(path));
    }

    public RedisNamedScript loadScript(RedisScriptSource source) throws IOException {
        RedisScriptParser parser = new RedisScriptParser(this, source);
        RedisNamedScript namedScript = parser.parse();
        this.addNamedScript(namedScript);
        return namedScript;
    }

    public void logScriptInfo(String name) {
        RedisNamedScript script = this.getNamedScript(name);
        log.info("\n[Redis] Script Info:\n[Name: " + script.getName() + "]\n[Path: " + script.getSource().getUrl().getPath() + "]\n[SHA: " + script.getSha() + "][\u7f16\u8bd1\u7ed3\u679c]: \n\n" + script.getScript() + "\n\n");
    }

    public void pushScriptToRedisServer(RedissonClient redissonClient, String name) {
        RedisNamedScript script = this.getNamedScript(name);
        script.load(redissonClient);
        log.info("\n[Redis] Script Info:\n[Name: " + script.getName() + "]\n[Path: " + script.getSource().getUrl().getPath() + "]\n[SHA: " + script.getSha() + "]");
    }

    public void pushAllScriptsToRedisServer(RedissonClient redissonClient) {
        for (String name : this.namedScriptMap.keySet()) {
            this.pushScriptToRedisServer(redissonClient, name);
        }
    }

    public RedisNamedScript loadScript(URL url) throws IOException {
        RedisScriptSource source = this.loadScriptSource(url);
        RedisNamedScript script = this.loadScript(source);
        return script;
    }
}

