/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.enums.FileTypeEnum;
import com.thebeastshop.common.utils.ByteUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String[] IMAGE_NAMES = new String[]{"bmp", "dib", "gif", "jfif", "jpe", "jpeg", "jpg", "png", "tif", "tiff", "ico"};
    private static final Map<MagicFileNumber, FileTypeEnum> FILE_TYPE = new HashMap<MagicFileNumber, FileTypeEnum>(){
        {
            this.put(new MagicFileNumber("FFD8FF", MagicNumPositionEnum.front, 0, 0), FileTypeEnum.JPG);
            this.put(new MagicFileNumber("89504E47", MagicNumPositionEnum.front, 0, 0), FileTypeEnum.PNG);
            this.put(new MagicFileNumber("47494638", MagicNumPositionEnum.front, 0, 0), FileTypeEnum.GIF);
            this.put(new MagicFileNumber("5249464", MagicNumPositionEnum.front, 0, 0), FileTypeEnum.WAV);
            this.put(new MagicFileNumber("4944330", MagicNumPositionEnum.front, 0, 0), FileTypeEnum.MP3);
            this.put(new MagicFileNumber("41564920", MagicNumPositionEnum.front, 0, 0), FileTypeEnum.AVI);
            this.put(new MagicFileNumber("66747970", MagicNumPositionEnum.middle, 8, 16), FileTypeEnum.MP4);
        }
    };

    public static boolean createDirectory(File file) {
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    public static boolean createDirectory(String dirname) {
        return FileUtil.createDirectory(new File(dirname));
    }

    public static String readFile2String(String filename) throws IOException {
        return FileUtil.readFile2String(new File(filename));
    }

    public static String readFile2String(File file) throws IOException {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        return FileUtil.readInputStream2String(new FileInputStream(file));
    }

    public static String readInputStream2String(InputStream is) throws IOException {
        return FileUtil.readInputStream2String(is, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readInputStream2String(InputStream is, String charset) throws IOException {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            br = new BufferedReader(new InputStreamReader(is, charset));
            String str = null;
            while ((str = br.readLine()) != null) {
                sb.append(str).append(LINE_SEPARATOR);
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeIO(br);
            throw throwable;
        }
        FileUtil.closeIO(br);
        return sb.toString().trim();
    }

    public static List<String> readFile2List(String filename) throws IOException {
        return FileUtil.readFile2List(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(File file) throws IOException {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        BufferedReader br = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            br = new BufferedReader(new FileReader(file));
            String str = null;
            while ((str = br.readLine()) != null) {
                list.add(str);
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeIO(br);
            throw throwable;
        }
        FileUtil.closeIO(br);
        return list;
    }

    public static void writeString2File(String str, String filename) throws IOException {
        FileUtil.writeString2File(str, new File(filename));
    }

    public static void writeString2File(String str, File file) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter((Writer)new FileWriterWithEncoding(file, "UTF-8"));
            bw.write(str);
            bw.flush();
        }
        catch (Throwable throwable) {
            FileUtil.closeIO(bw);
            throw throwable;
        }
        FileUtil.closeIO(bw);
    }

    public static void writeList2File(List<String> list, String filename) throws IOException {
        FileUtil.writeList2File(list, new File(filename), LINE_SEPARATOR);
    }

    public static void writeList2File(List<String> list, File file) throws IOException {
        FileUtil.writeList2File(list, file, LINE_SEPARATOR);
    }

    public static void writeList2File(List<String> list, String filename, String lineSeparator) throws IOException {
        FileUtil.writeList2File(list, new File(filename), lineSeparator);
    }

    public static void writeList2File(List<String> list, File file, String lineSeparator) throws IOException {
        StringBuffer sb = new StringBuffer();
        int k = list.size();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                sb.append(lineSeparator);
            }
            sb.append(list.get(i));
        }
        FileUtil.writeString2File(sb.toString(), file);
    }

    public static void closeIO(Closeable io) throws IOException {
        if (io != null) {
            io.close();
        }
    }

    public static void zipFile(File inFile, File outFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        ZipEntry ze = new ZipEntry(inFile.getName());
        zos.putNextEntry(ze);
        byte[] buf = new byte[2048];
        int readLen = 0;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(inFile));
        while ((readLen = ((InputStream)is).read(buf, 0, 2048)) != -1) {
            zos.write(buf, 0, readLen);
        }
        ((InputStream)is).close();
        zos.close();
    }

    public static byte[] getBytes(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static FileTypeEnum getFileType(String filePath) {
        return FileUtil.getFileType(new File(filePath));
    }

    public static FileTypeEnum getFileType(File file) {
        FileTypeEnum fileType = null;
        try {
            fileType = FileUtil.getFileType(new FileInputStream(file));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u7c7b\u578b\u5f02\u5e38: {}", (Throwable)e);
        }
        return fileType;
    }

    public static FileTypeEnum getFileType(InputStream inputStream) {
        FileTypeEnum fileType = null;
        try {
            byte[] b = new byte[28];
            inputStream.read(b);
            String hex = ByteUtil.bytes2Hex(b).toUpperCase();
            logger.info("\u6587\u4ef6\u9b54\u6570\u503c: {}", (Object)hex);
            String middleHex = null;
            for (Map.Entry<MagicFileNumber, FileTypeEnum> entry : FILE_TYPE.entrySet()) {
                if (entry.getKey().getPosition().equals((Object)MagicNumPositionEnum.front)) {
                    if (!hex.startsWith(entry.getKey().getMagicNumber())) continue;
                    fileType = entry.getValue();
                } else {
                    if (!entry.getKey().getPosition().equals((Object)MagicNumPositionEnum.middle) || !(middleHex = hex.substring(entry.getKey().getMiddleStart(), entry.getKey().getMiddleEnd())).equals(entry.getKey().getMagicNumber())) continue;
                    fileType = entry.getValue();
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u7c7b\u578b\u5f02\u5e38: {}", (Throwable)e);
        }
        return fileType;
    }

    public static String getExtName(String fileName) {
        if (EmptyUtil.isEmpty(fileName)) {
            return "";
        }
        if (!fileName.contains(".")) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static boolean isImageExtName(String extName) {
        boolean result = false;
        if (EmptyUtil.isNotEmpty(extName) && ArrayUtils.contains((Object[])IMAGE_NAMES, (Object)extName.toLowerCase())) {
            result = true;
        }
        return result;
    }

    public static Boolean exists(String filePath) {
        File file;
        Boolean result = false;
        if (EmptyUtil.isNotEmpty(filePath) && (file = new File(filePath)).exists() && file.canRead()) {
            result = true;
        }
        return result;
    }

    public static byte[] getByteFileData(String filePath) throws IOException {
        if (FileUtil.exists(filePath).booleanValue()) {
            File file = new File(filePath);
            return FileUtils.readFileToByteArray((File)file);
        }
        throw new IOException("file is not exist");
    }

    public static Boolean InputStreamTOFile(InputStream in, String filePath) throws IOException {
        if (EmptyUtil.isNotEmpty(in) && EmptyUtil.isNotEmpty(filePath)) {
            File file = new File(filePath);
            byte[] b = IOUtils.toByteArray((InputStream)in);
            FileUtils.writeByteArrayToFile((File)file, (byte[])b);
            IOUtils.closeQuietly((InputStream)in);
            return true;
        }
        return false;
    }

    public static Boolean resizeImage(int width, int height, String filePath) throws IOException {
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        BufferedImage targetImage = ImageIO.read(new File(filePath));
        BufferedImage image = new BufferedImage(width, height, 1);
        image.getGraphics().drawImage(targetImage, 0, 0, width, height, Color.WHITE, null);
        String formatName = filePath.substring(filePath.lastIndexOf(".") + 1);
        return ImageIO.write((RenderedImage)image, formatName, new File(filePath));
    }

    public static void resizeImage(int width, int height, String filePath, boolean fillWhite) {
        try {
            double ratio = 0.0;
            File file = new File(filePath);
            BufferedImage tempBufferedImage = ImageIO.read(file);
            Image targetImage = tempBufferedImage.getScaledInstance(width, height, 4);
            if (tempBufferedImage.getHeight() > height || tempBufferedImage.getWidth() > width) {
                ratio = tempBufferedImage.getHeight() > tempBufferedImage.getWidth() ? new Integer(height).doubleValue() / (double)tempBufferedImage.getHeight() : new Integer(width).doubleValue() / (double)tempBufferedImage.getWidth();
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                targetImage = op.filter(tempBufferedImage, null);
            }
            if (fillWhite) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D graphics2D = image.createGraphics();
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, width, height);
                if (width == targetImage.getWidth(null)) {
                    graphics2D.drawImage(targetImage, 0, (height - targetImage.getHeight(null)) / 2, targetImage.getWidth(null), targetImage.getHeight(null), Color.white, null);
                } else {
                    graphics2D.drawImage(targetImage, (width - targetImage.getWidth(null)) / 2, 0, targetImage.getWidth(null), targetImage.getHeight(null), Color.white, null);
                }
                graphics2D.dispose();
                targetImage = image;
            }
            ImageIO.write((RenderedImage)((BufferedImage)targetImage), "jpg", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        FileTypeEnum fileType = FileUtil.getFileType(new File("D:/1.png"));
        System.out.println(fileType);
    }

    private static class MagicFileNumber {
        private String magicNumber;
        private MagicNumPositionEnum position;
        private int middleStart;
        private int middleEnd;

        public MagicFileNumber(String magicNumber, MagicNumPositionEnum position, int middleStart, int middleEnd) {
            this.magicNumber = magicNumber;
            this.position = position;
            this.middleStart = middleStart;
            this.middleEnd = middleEnd;
        }

        public String getMagicNumber() {
            return this.magicNumber;
        }

        public void setMagicNumber(String magicNumber) {
            this.magicNumber = magicNumber;
        }

        public MagicNumPositionEnum getPosition() {
            return this.position;
        }

        public void setPosition(MagicNumPositionEnum position) {
            this.position = position;
        }

        public int getMiddleStart() {
            return this.middleStart;
        }

        public void setMiddleStart(int middleStart) {
            this.middleStart = middleStart;
        }

        public int getMiddleEnd() {
            return this.middleEnd;
        }

        public void setMiddleEnd(int middleEnd) {
            this.middleEnd = middleEnd;
        }
    }

    private static enum MagicNumPositionEnum {
        front,
        middle,
        end;

    }
}

