/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.spring;

import com.thebeastshop.common.converter.AfterCopyProperties;
import com.thebeastshop.common.converter.BeanConverterHandler;
import com.thebeastshop.common.converter.ConverterSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ReflectionUtils;

public class BeanConverterManager
implements BeanPostProcessor,
PriorityOrdered {
    private static final Logger log = LoggerFactory.getLogger(BeanConverterManager.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.processMethods(bean);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void processMethods(final Object bean) {
        Method[] methods;
        Class<?> clazz = bean.getClass();
        for (final Method method : methods = clazz.getDeclaredMethods()) {
            AfterCopyProperties ann = method.getAnnotation(AfterCopyProperties.class);
            if (ann == null) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != 2) {
                throw new RuntimeException("\u81ea\u5b9a\u4e49\u7c7b\u578b\u8f6c\u6362\u65b9\u6cd5\u53c2\u6570\u6570\u91cf\u5fc5\u987b\u4e3a2\u4e2a\uff01");
            }
            String description = ann.value();
            String logDesc = "";
            if (StringUtils.isNotBlank((String)description)) {
                logDesc = " [" + description + "] ";
            }
            log.info("[\u81ea\u5b9a\u4e49\u7c7b\u578b\u8f6c\u6362] \u626b\u63cf\u5230\u81ea\u5b9a\u4e49\u7c7b\u578b\u8f6c\u6362\u65b9\u6cd5 " + logDesc + "[" + clazz.getName() + "." + method.getName() + "]");
            ReflectionUtils.makeAccessible((Method)method);
            ConverterSupport.from(paramTypes[0]).to(paramTypes[1]).afterCopy(new BeanConverterHandler(){

                public void copyFields(Object sourceObj, Object targetObj) {
                    try {
                        method.invoke(bean, sourceObj, targetObj);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

