package com.thebeastshop.common.prop;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2018-05-21 15:41
 */
public abstract class PropPatternProcessor {
    private final static Logger log = LoggerFactory.getLogger(PropPatternProcessor.class);

    protected String prefix;
    protected String suffix;

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isMatch(String propName) {
        if (StringUtils.isEmpty(propName)) {
            return false;
        }
        if (getPrefix() == null && getSuffix() == null) {
            return false;
        }
        boolean prefixOk = true;
        boolean suffixOk = true;
        StringBuilder  builder = new StringBuilder();
        if (getPrefix() != null) {
            String pattern = getPrefix() + ".";
            prefixOk = propName.startsWith(pattern) && propName.length() > pattern.length();
            if (prefixOk) {
                builder.append(" prefix: " + getPrefix());
            }
        }
        if (getSuffix() != null) {
            String pattern = "." + getSuffix();
            suffixOk = propName.endsWith(pattern) && propName.length() > pattern.length();
            if (suffixOk) {
                builder.append(" suffix: " + suffix);
            }
        }
        if (prefixOk && suffixOk) {
            log.info(" [Prop] Matched property \"" + propName + "\" with [" + builder.toString() + " ]");
            return true;
        }
        return false;
    }

    public abstract void process(String propName, Object value);

    public void matchAndProcess(String propName, Object value) {
        if (isMatch(propName)) {
            process(propName, value);
        }
    }
}
