package com.thebeastshop.common;

import com.thebeastshop.common.exception.BaseErrorCode;
import com.thebeastshop.common.exception.BaseServiceException;

import java.util.HashMap;
import java.util.Map;

public class ServiceResp<T> extends BaseDO {
	private static final long serialVersionUID = 1L;

	private String appId;

	private String respCode;
	
	private String respMsg;

	private Map<String, Object> errorData;

	private boolean isSuccess = true;
	
	private T bean;

	@Deprecated
	public ServiceResp() {
	}

	public static <T> ServiceResp<T> newInstanceSuccess(){
		return ServiceResp.newInstanceSuccess(null);
	}
	
	public static <T> ServiceResp<T> newInstanceSuccess(T bean) {
		ServiceResp<T> serviceResp = new ServiceResp<T>();
		serviceResp.setBean(bean);
		return serviceResp;
	}
	
	public static <T> ServiceResp<T> newInstanceFail(String msg){
		return ServiceResp.newInstanceFail(500, msg);
	}
	
	public static <T> ServiceResp<T> newInstanceDataNotFoundFail(String msg){
		return ServiceResp.newInstanceFail(404, msg);
	}
	
	public static <T> ServiceResp<T> newInstanceFail(Integer code, String msg){
		return ServiceResp.newInstanceFail(code + "", msg);
	}

	public static <T> ServiceResp<T> newInstanceFail(BaseErrorCode errorCode, String msg) {
		return ServiceResp.newInstanceFail(errorCode.getErrorCode(), errorCode.getMessage() + ": " + msg);
	}

	public static <T> ServiceResp<T> newInstanceFail(BaseErrorCode errorCode) {
		return ServiceResp.newInstanceFail(errorCode.getErrorCode(), errorCode.getMessage());
	}

	public static <T> ServiceResp<T> newInstanceFail(Throwable t) {
		if (t instanceof BaseServiceException) {
			BaseServiceException ex = (BaseServiceException) t;
			return ServiceResp.newInstanceFail(ex);
		}
		return ServiceResp.newInstanceFail(t.getMessage());
	}

	public static <T> ServiceResp<T> newInstanceFail(BaseServiceException ex) {
		return ServiceResp.newInstanceFail(
				ex.getErrorCode(),
				ex.getMessage(),
				ex.getErrorData());
	}

	public static <T> ServiceResp<T> newInstanceFail(Exception e, BaseErrorCode errorCode) {
		if (e instanceof BaseServiceException) {
			return newInstanceFail((BaseServiceException) e);
		}
		return newInstanceFail(errorCode, e.getMessage());
	}

	public static <T> ServiceResp<T> newInstanceFail(String code, String msg) {
		return newInstanceFail(code, msg, new HashMap<String, Object>());
	}

	public static <T> ServiceResp<T> newInstanceFail(String code, String msg, Map<String, Object> errorData){
		ServiceResp<T> serviceResp = new ServiceResp<T>();
		serviceResp.setRespCode(code);
		serviceResp.setRespMsg(msg);
		serviceResp.setErrorData(errorData);
		serviceResp.setSuccess(false);
		return serviceResp;
	}

	public String getRespCode() {
		return respCode;
	}
	public void setRespCode(String respCode) {
		this.respCode = respCode;
	}

	public String getRespMsg() {
		return respMsg;
	}

	public void setRespMsg(String respMsg) {
		this.respMsg = respMsg;
	}

	public T getBean() {
		return bean;
	}

	public void setBean(T bean) {
		this.bean = bean;
	}

	public Map<String, Object> getErrorData() {
		return errorData;
	}

	public void setErrorData(Map<String, Object> errorData) {
		this.errorData = errorData;
	}

	public boolean isSuccess() {
		return isSuccess;
	}

	public void setSuccess(boolean success) {
		isSuccess = success;
	}

	public boolean isFailure() {
		return !isSuccess();
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public ServiceResp<T> checkError(String code, RespCallback respCallback) {
		if (isFailure()) {
			if (code != null && code.equals(respCode)) {
				respCallback.call(respCode, respMsg, errorData);
			}
		}
		return this;
	}

	public ServiceResp<T> checkError(BaseErrorCode code, RespCallback respCallback) {
		return checkError(code.getErrorCode(), respCallback);
	}

	public ServiceResp<T> checkError(RespCallback respCallback) {
		if (isFailure()) {
			respCallback.call(respCode, respMsg, errorData);
		}
		return this;

	}
}