/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.redis;

import com.thebeastshop.common.redis.RedisScriptManager;
import com.thebeastshop.common.redis.RedisScriptSource;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class RedisScriptScanner
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RedisScriptScanner.class);
    private String location;
    private RedissonClient redissonClient;
    private final RedisScriptManager scriptManager = RedisScriptManager.scriptManager();

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public RedissonClient getRedissonClient() {
        return this.redissonClient;
    }

    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public void scan() throws IOException {
        Resource[] resources;
        if (StringUtils.isBlank((CharSequence)this.location)) {
            return;
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (Resource resource : resources = resolver.getResources(this.location)) {
            RedisScriptSource source = this.scriptManager.loadScriptSource(resource.getURL());
            this.scriptManager.loadScript(source);
        }
        this.scriptManager.pushAllScriptsToRedisServer(this.redissonClient);
    }

    private String getScriptName(String filename) {
        String[] segments = filename.split("/|\\\\");
        return segments[segments.length - 1];
    }

    public void afterPropertiesSet() throws Exception {
        this.scan();
    }
}

