package com.thebeastshop.common;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;

/**
 * <p>
 * Title: thebeastshop
 * </p>
 * <p>
 * Copyright: Copyright (c) 2016
 * </p>
 * 
 * @author Bryan Zhang
 * @date 2017-1-17
 * @description
 */
public abstract class BaseDO implements Serializable, ByteHandler {
	private static final long serialVersionUID = 1L;

	protected final transient Logger log = LoggerFactory.getLogger(getClass());

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
	}

	/**
	 * 转成map形式
	 */
	public Map<String, Object> toMap() {
		Map<String, Object> returnMap = new LinkedHashMap<String, Object>();
		try {
			PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
			for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
				String propertyName = propertyDescriptor.getName();
				if ("class".equals(propertyName)) {
					continue;
				}
				Method readMethod = propertyDescriptor.getReadMethod();
				Object result = readMethod.invoke(this, new Object[0]);
				returnMap.put(propertyName, result);
			}
		} catch (Exception e) {
			log.error("toMap ERROR.", e);
		}
		return returnMap;
	}

	public String toJson() {
		return JSONObject.toJSONString(this);
	}

	public byte[] toByteArray() {
		return toJson().getBytes(Charset.forName("UTF-8"));
	}

	public void mergeFrom(ByteBuffer byteBuffer) {
		String s = new String(byteBuffer.array(), Charset.forName("UTF-8"));
		Object orig = JSONObject.parseObject(s, this.getClass());
		try {
			BeanUtils.copyProperties(this, orig);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
