/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.limit;

import com.thebeastshop.common.limit.LimitFallbackEnable;
import com.thebeastshop.common.limit.LimitFallbackInvocation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitFallbackInvoker {
    private static final Logger log = LoggerFactory.getLogger(LimitFallbackInvoker.class);
    private static final String ROLLBACK_METHOD_PREFIX = "rollback";
    private Map<String, LimitFallbackInvocation> fallbackInvocations = new HashMap<String, LimitFallbackInvocation>();

    public LimitFallbackInvoker(Object bean) {
        this.initMethods(bean, bean.getClass());
    }

    public LimitFallbackInvocation findFallbackInvocation(String name, Class[] paramTypes) {
        String key = this.methodKey(name, paramTypes);
        return this.fallbackInvocations.get(key);
    }

    private Method[] getDeclaredMethods(Class clazz) {
        return clazz.getDeclaredMethods();
    }

    private String methodKey(String name, Class[] paramTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(name).append('(');
        int len = paramTypes.length;
        for (int i = 0; i < len; ++i) {
            Class pType = paramTypes[i];
            builder.append(pType.getName());
            if (i >= len - 1) continue;
            builder.append(',');
        }
        builder.append(')');
        return builder.toString();
    }

    public void initMethods(Object bean, Class clazz) {
        for (Class searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            Method[] marr = methods = searchType.isInterface() ? searchType.getMethods() : this.getDeclaredMethods(searchType);
            int len = methods.length;
            for (int i = 0; i < len; ++i) {
                Method method = marr[i];
                String name = method.getName();
                Class[] paramTypes = method.getParameterTypes();
                String key = this.methodKey(name, paramTypes);
                if (name.startsWith(ROLLBACK_METHOD_PREFIX)) {
                    LimitFallbackInvocation invocation = new LimitFallbackInvocation(null, null);
                    invocation.setRollback(true);
                    log.info("[SENTINEL] --- \u6620\u5c04\u4e0d\u505a\u964d\u7ea7\u7684Rollback\u65b9\u6cd5: " + key);
                    this.fallbackInvocations.put(key, invocation);
                    continue;
                }
                LimitFallbackEnable ann = null;
                try {
                    ann = method.getAnnotation(LimitFallbackEnable.class);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (ann == null) continue;
                log.info("[SENTINEL] --- \u6620\u5c04Fallback\u65b9\u6cd5: " + key);
                this.fallbackInvocations.put(key, new LimitFallbackInvocation(bean, method));
            }
        }
    }
}

