/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.enums.FileTypeEnum;
import com.thebeastshop.common.utils.ByteUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Map<MagicFileNumber, FileTypeEnum> FILE_TYPE = new HashMap<MagicFileNumber, FileTypeEnum>(){
        {
            this.put(new MagicFileNumber("FFD8FF", MagicNumPositionEnum.front, 0, 0), FileTypeEnum.JPG);
            this.put(new MagicFileNumber("89504E47", MagicNumPositionEnum.front, 0, 0), FileTypeEnum.PNG);
            this.put(new MagicFileNumber("47494638", MagicNumPositionEnum.front, 0, 0), FileTypeEnum.GIF);
            this.put(new MagicFileNumber("5249464", MagicNumPositionEnum.front, 0, 0), FileTypeEnum.WAV);
            this.put(new MagicFileNumber("4944330", MagicNumPositionEnum.front, 0, 0), FileTypeEnum.MP3);
            this.put(new MagicFileNumber("41564920", MagicNumPositionEnum.front, 0, 0), FileTypeEnum.AVI);
            this.put(new MagicFileNumber("66747970", MagicNumPositionEnum.middle, 8, 16), FileTypeEnum.MP4);
        }
    };

    public static boolean createDirectory(File file) {
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    public static boolean createDirectory(String dirname) {
        return FileUtil.createDirectory(new File(dirname));
    }

    public static String readFile2String(String filename) throws IOException {
        return FileUtil.readFile2String(new File(filename));
    }

    public static String readFile2String(File file) throws IOException {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        return FileUtil.readInputStream2String(new FileInputStream(file));
    }

    public static String readInputStream2String(InputStream is) throws IOException {
        return FileUtil.readInputStream2String(is, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readInputStream2String(InputStream is, String charset) throws IOException {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            br = new BufferedReader(new InputStreamReader(is, charset));
            String str = null;
            while ((str = br.readLine()) != null) {
                sb.append(str).append(LINE_SEPARATOR);
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeIO(br);
            throw throwable;
        }
        FileUtil.closeIO(br);
        return sb.toString().trim();
    }

    public static List<String> readFile2List(String filename) throws IOException {
        return FileUtil.readFile2List(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(File file) throws IOException {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        BufferedReader br = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            br = new BufferedReader(new FileReader(file));
            String str = null;
            while ((str = br.readLine()) != null) {
                list.add(str);
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeIO(br);
            throw throwable;
        }
        FileUtil.closeIO(br);
        return list;
    }

    public static void writeString2File(String str, String filename) throws IOException {
        FileUtil.writeString2File(str, new File(filename));
    }

    public static void writeString2File(String str, File file) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter((Writer)new FileWriterWithEncoding(file, "UTF-8"));
            bw.write(str);
            bw.flush();
        }
        catch (Throwable throwable) {
            FileUtil.closeIO(bw);
            throw throwable;
        }
        FileUtil.closeIO(bw);
    }

    public static void writeList2File(List<String> list, String filename) throws IOException {
        FileUtil.writeList2File(list, new File(filename), LINE_SEPARATOR);
    }

    public static void writeList2File(List<String> list, File file) throws IOException {
        FileUtil.writeList2File(list, file, LINE_SEPARATOR);
    }

    public static void writeList2File(List<String> list, String filename, String lineSeparator) throws IOException {
        FileUtil.writeList2File(list, new File(filename), lineSeparator);
    }

    public static void writeList2File(List<String> list, File file, String lineSeparator) throws IOException {
        StringBuffer sb = new StringBuffer();
        int k = list.size();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                sb.append(lineSeparator);
            }
            sb.append(list.get(i));
        }
        FileUtil.writeString2File(sb.toString(), file);
    }

    public static void closeIO(Closeable io) throws IOException {
        if (io != null) {
            io.close();
        }
    }

    public static void zipFile(File inFile, File outFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        ZipEntry ze = new ZipEntry(inFile.getName());
        zos.putNextEntry(ze);
        byte[] buf = new byte[2048];
        int readLen = 0;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(inFile));
        while ((readLen = ((InputStream)is).read(buf, 0, 2048)) != -1) {
            zos.write(buf, 0, readLen);
        }
        ((InputStream)is).close();
        zos.close();
    }

    public static byte[] getBytes(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static FileTypeEnum getFileType(String filePath) {
        return FileUtil.getFileType(new File(filePath));
    }

    public static FileTypeEnum getFileType(File file) {
        FileTypeEnum fileType = null;
        try {
            fileType = FileUtil.getFileType(new FileInputStream(file));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u7c7b\u578b\u5f02\u5e38: {}", (Throwable)e);
        }
        return fileType;
    }

    public static FileTypeEnum getFileType(InputStream inputStream) {
        FileTypeEnum fileType = null;
        try {
            byte[] b = new byte[28];
            inputStream.read(b);
            String hex = ByteUtil.bytes2Hex(b).toUpperCase();
            logger.info("\u6587\u4ef6\u9b54\u6570\u503c: {}", (Object)hex);
            String middleHex = null;
            for (Map.Entry<MagicFileNumber, FileTypeEnum> entry : FILE_TYPE.entrySet()) {
                if (entry.getKey().getPosition().equals((Object)MagicNumPositionEnum.front)) {
                    if (!hex.startsWith(entry.getKey().getMagicNumber())) continue;
                    fileType = entry.getValue();
                } else {
                    if (!entry.getKey().getPosition().equals((Object)MagicNumPositionEnum.middle) || !(middleHex = hex.substring(entry.getKey().getMiddleStart(), entry.getKey().getMiddleEnd())).equals(entry.getKey().getMagicNumber())) continue;
                    fileType = entry.getValue();
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u7c7b\u578b\u5f02\u5e38: {}", (Throwable)e);
        }
        return fileType;
    }

    public static void main(String[] args) {
        FileTypeEnum fileType = FileUtil.getFileType(new File("D:/1.png"));
        System.out.println(fileType);
    }

    private static class MagicFileNumber {
        private String magicNumber;
        private MagicNumPositionEnum position;
        private int middleStart;
        private int middleEnd;

        public MagicFileNumber(String magicNumber, MagicNumPositionEnum position, int middleStart, int middleEnd) {
            this.magicNumber = magicNumber;
            this.position = position;
            this.middleStart = middleStart;
            this.middleEnd = middleEnd;
        }

        public String getMagicNumber() {
            return this.magicNumber;
        }

        public void setMagicNumber(String magicNumber) {
            this.magicNumber = magicNumber;
        }

        public MagicNumPositionEnum getPosition() {
            return this.position;
        }

        public void setPosition(MagicNumPositionEnum position) {
            this.position = position;
        }

        public int getMiddleStart() {
            return this.middleStart;
        }

        public void setMiddleStart(int middleStart) {
            this.middleStart = middleStart;
        }

        public int getMiddleEnd() {
            return this.middleEnd;
        }

        public void setMiddleEnd(int middleEnd) {
            this.middleEnd = middleEnd;
        }
    }

    private static enum MagicNumPositionEnum {
        front,
        middle,
        end;

    }
}

